/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.lang.aspectj.psi.AjAdvice;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.PsiInterTypeAnnotation;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjHighlightInfoFilter
implements HighlightInfoFilter {
    public boolean accept(@NotNull HighlightInfo info, @Nullable PsiFile file) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/aspectj/highlight/AjHighlightInfoFilter", "accept"));
        }
        if (info.getDescription() == null || !(file instanceof PsiAspectJFile)) {
            return true;
        }
        PsiElement element = file.findElementAt(info.getStartOffset());
        if (element == null || !element.isValid()) {
            return true;
        }
        if (JavaErrorMessages.message((String)"return.outside.method", (Object[])new Object[0]).equals(info.getDescription())) {
            return !AjHighlightInfoFilter.isInAdvice(element);
        }
        if (info.getDescription().contains(" has private access in ")) {
            PsiElement target = AjHighlightInfoFilter.resolve(PsiTreeUtil.getParentOfType((PsiElement)element, PsiJavaCodeReferenceElement.class, (boolean)false));
            if (target instanceof PsiMember && ((PsiMember)target).hasModifierProperty("private")) {
                return !AjHighlightInfoFilter.isInAdvice(element);
            }
        } else {
            if (JavaErrorMessages.message((String)"annotation.not.allowed.here", (Object[])new Object[0]).equals(info.getDescription())) {
                PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
                if (annotation == null) {
                    return true;
                }
                PsiElement parent = annotation.getParent();
                return !(parent instanceof PsiInterTypeAnnotation) && (!(parent instanceof PsiModifierList) || !(parent.getParent() instanceof AjAdvice));
            }
            if (JavaErrorMessages.message((String)"illegal.type.void", (Object[])new Object[0]).equals(info.getDescription())) {
                PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
                return typeElement == null || !(typeElement.getParent() instanceof AjAdvice);
            }
        }
        return true;
    }

    private static boolean isInAdvice(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMember.class, AjAdvice.class}) instanceof AjAdvice;
    }

    @Nullable
    private static PsiElement resolve(PsiElement element) {
        return element instanceof PsiReference ? ((PsiReference)element).resolve() : null;
    }
}

