/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.member;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.augment.AjPsiAugmentProvider;
import com.intellij.lang.aspectj.highlight.analysis.AnnotationUtil;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;

public class DuplicateFieldsInAspectAnnotator
extends ElementAnnotator<PsiField> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiField field) {
        PsiClass aClass = field.getContainingClass();
        if (aClass == null || aClass.isEnum()) {
            return false;
        }
        PsiInterTypeDeclaration copy = null;
        for (PsiField other : AjPsiAugmentProvider.getAjAugments((PsiElement)aClass, PsiField.class)) {
            if (field == other || !field.getName().equals(other.getName()) || AnnotationUtil.nonIntersecting((PsiMember)field, (PsiMember)other)) continue;
            copy = (PsiInterTypeDeclaration)other;
            break;
        }
        if (copy == null) {
            return false;
        }
        TextRange range = HighlightNamesUtil.getFieldDeclarationTextRange((PsiField)field);
        AnnotationUtil.createErrorAnnotation(holder, range, AspectJBundle.message("highlighting.declaration.conflict.in.class", field.getName(), copy.getAspect().getQualifiedName()), AspectJBundle.message("highlighting.declaration.conflict.in.class", field.getName(), AnnotationUtil.link(copy, copy.getAspect().getQualifiedName())));
        return true;
    }
}

