/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.member;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.AnnotationUtil;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;

public class DuplicateFieldsInClassAnnotator
extends ElementAnnotator<PsiField> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiField field) {
        PsiClass aClass = field.getContainingClass();
        if (aClass == null || aClass.isEnum()) {
            return false;
        }
        PsiField copy = null;
        for (PsiField other : aClass.getFields()) {
            if (other instanceof ExternallyDefinedPsiElement || !other.getName().equals(field.getName()) || AnnotationUtil.nonIntersecting((PsiMember)field, (PsiMember)other)) continue;
            copy = other;
            break;
        }
        if (copy == null) {
            return false;
        }
        TextRange range = HighlightNamesUtil.getFieldDeclarationTextRange((PsiField)field);
        AnnotationUtil.createErrorAnnotation(holder, range, AspectJBundle.message("highlighting.declaration.conflict.in.aspect", field.getName(), aClass.getQualifiedName()), AspectJBundle.message("highlighting.declaration.conflict.in.aspect", field.getName(), AnnotationUtil.link((PsiElement)copy, aClass.getQualifiedName())));
        return true;
    }
}

