/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.ref;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;

public class TypeReferenceListAnnotator1
extends ElementAnnotator<PsiIdentifier> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiIdentifier identifier) {
        PsiElement parent = identifier.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiTypeElement)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiReferenceParameterList)) {
            return false;
        }
        PsiReferenceParameterList refParamList = (PsiReferenceParameterList)parent;
        if (!((parent = parent.getParent()) instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiTypeElement)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiInterTypeReference)) {
            return false;
        }
        PsiClass target = ((PsiInterTypeReference)parent).getReferencedClass();
        if (target == null) {
            return false;
        }
        int required = target.getTypeParameters().length;
        if (required == refParamList.getTypeParameterElements().length) {
            return false;
        }
        String targetName = HighlightMessageUtil.getSymbolName((PsiElement)target, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String message = required == 0 ? AspectJBundle.message("highlighting.target.not.generic", targetName) : AspectJBundle.message("highlighting.wrong.num.of.type.refs", targetName, required);
        holder.createErrorAnnotation((PsiElement)refParamList, message);
        return true;
    }
}

