/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiParser;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.parsing.IAspectJElementType;
import com.intellij.lang.aspectj.parsing.lexer.AjLexer;
import com.intellij.lang.aspectj.psi.impl.PsiAspectJFileImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import org.jetbrains.annotations.NotNull;

public class AjParserDefinition
extends JavaParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        AjLexer ajLexer = new AjLexer();
        if (ajLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/parsing/AjParserDefinition", "createLexer"));
        }
        return ajLexer;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = AspectJElementType.FILE;
        if (iFileElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/parsing/AjParserDefinition", "getFileNodeType"));
        }
        return iFileElementType;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof AjStubElementType) {
            Object p = ((AjStubElementType)type).createPsi(node);
            if (p == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/parsing/AjParserDefinition", "createElement"));
            }
            return p;
        }
        if (type instanceof IAspectJElementType) {
            PsiElement psiElement = ((IAspectJElementType)type).createPsi(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/parsing/AjParserDefinition", "createElement"));
            }
            return psiElement;
        }
        throw new IllegalStateException("Incorrect node for AjParserDefinition: " + node + " (" + type + ")");
    }

    @NotNull
    public PsiFile createFile(FileViewProvider fileViewProvider) {
        PsiAspectJFileImpl psiAspectJFileImpl = new PsiAspectJFileImpl(fileViewProvider);
        if (psiAspectJFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/parsing/AjParserDefinition", "createFile"));
        }
        return psiAspectJFileImpl;
    }
}

