/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.parsing.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.parsing.AspectJTokenType;
import com.intellij.lang.aspectj.parsing.parser.AjParserUtil;
import com.intellij.lang.aspectj.parsing.parser.AjReferenceParser;
import com.intellij.lang.aspectj.parsing.parser.AjStatementParser;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjDeclarationParser
extends DeclarationParser {
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD});
    private static final TokenSet PER_CLAUSE_SET = TokenSet.create((IElementType[])new IElementType[]{AspectJTokenType.ISSINGLETON_KEYWORD, AspectJTokenType.PERCFLOW_KEYWORD, AspectJTokenType.PERCFLOWBELOW_KEYWORD, AspectJTokenType.PERTARGET_KEYWORD, AspectJTokenType.PERTHIS_KEYWORD, AspectJTokenType.PERTYPE_KEYWORD, AspectJTokenType.PERTYPEWITHIN_KEYWORD});
    private static final TokenSet ADVICE_KEYWORDS_SET = TokenSet.create((IElementType[])new IElementType[]{AspectJTokenType.AFTER_KEYWORD, AspectJTokenType.AROUND_KEYWORD, AspectJTokenType.BEFORE_KEYWORD});
    private static final TokenSet ADVICE_ADD_KEYWORDS_SET = TokenSet.create((IElementType[])new IElementType[]{AspectJTokenType.RETURNING_KEYWORD, AspectJTokenType.THROWING_KEYWORD});
    private static final TokenSet FIELD_CLOSING_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LBRACKET, JavaTokenType.EQ, JavaTokenType.SEMICOLON});
    private final JavaParser myParser;

    public AjDeclarationParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParser", "com/intellij/lang/aspectj/parsing/parser/AjDeclarationParser", "<init>"));
        }
        super(javaParser);
        this.myParser = javaParser;
    }

    public PsiBuilder.Marker parse(PsiBuilder builder, DeclarationParser.Context context) {
        PsiBuilder.Marker declaration = builder.mark();
        Pair modListInfo = this.parseModifierList(builder, AspectJTokenType.AJ_MODIFIER_BIT_SET);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (builder.getTokenType() == AspectJTokenType.ASPECT_KEYWORD) {
            PsiBuilder.Marker result = this.parseAspectFromKeyword(builder, declaration);
            return result != null ? result : modList;
        }
        declaration.rollbackTo();
        return super.parse(builder, context);
    }

    @Nullable
    public PsiBuilder.Marker parse(PsiBuilder builder, Context context) {
        PsiBuilder.Marker interClass;
        PsiBuilder.Marker declaration = builder.mark();
        if (context == Context.ASPECT && builder.getTokenType() == AspectJTokenType.DECLARE_KEYWORD) {
            return AjStatementParser.parseDeclare(builder, declaration);
        }
        Pair modListInfo = this.parseModifierList(builder, AspectJTokenType.AJ_MODIFIER_BIT_SET);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (builder.getTokenType() == AspectJTokenType.ASPECT_KEYWORD) {
            PsiBuilder.Marker result = this.parseAspectFromKeyword(builder, declaration);
            return result != null ? result : modList;
        }
        if (context == Context.FILE) {
            declaration.rollbackTo();
            return this.parseJavaDeclaration(builder, context);
        }
        if (builder.getTokenType() == AspectJTokenType.POINTCUT_KEYWORD) {
            PsiBuilder.Marker result = this.parsePointcut(builder, declaration);
            return result != null ? result : modList;
        }
        if (builder.getTokenType() == JavaTokenType.CLASS_KEYWORD && (interClass = this.parseInterClass(builder, declaration)) != null) {
            return interClass;
        }
        PsiBuilder.Marker advice = this.parseAdvice(builder, declaration);
        if (advice != null) {
            return advice;
        }
        PsiBuilder.Marker interMethod = this.parseInterMethod(builder, declaration, modList);
        if (interMethod != null) {
            return interMethod;
        }
        PsiBuilder.Marker interField = this.parseInterField(builder, declaration);
        if (interField != null) {
            return interField;
        }
        declaration.rollbackTo();
        return this.parseJavaDeclaration(builder, context);
    }

    @Nullable
    private PsiBuilder.Marker parseJavaDeclaration(PsiBuilder builder, Context context) {
        DeclarationParser.Context javaContext;
        if (context == Context.FILE) {
            javaContext = DeclarationParser.Context.FILE;
        } else if (context == Context.ASPECT) {
            javaContext = DeclarationParser.Context.CLASS;
        } else {
            throw new IllegalArgumentException("Unknown context: " + (Object)((Object)context));
        }
        return this.parse(builder, javaContext);
    }

    @Nullable
    private PsiBuilder.Marker parseAspectFromKeyword(PsiBuilder builder, PsiBuilder.Marker declaration) {
        assert (builder.getTokenType() == AspectJTokenType.ASPECT_KEYWORD) : builder.getTokenType();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.identifier", (Object[])new Object[0]));
            declaration.drop();
            return null;
        }
        return this.parseTypePastIdentifier(builder, declaration, (IElementType)AspectJElementType.ASPECT);
    }

    @NotNull
    private PsiBuilder.Marker parseTypePastIdentifier(PsiBuilder builder, PsiBuilder.Marker declaration, IElementType elementType) {
        ReferenceParser referenceParser = this.myParser.getReferenceParser();
        referenceParser.parseTypeParameters(builder);
        referenceParser.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_LIST, JavaTokenType.COMMA);
        referenceParser.parseReferenceList(builder, JavaTokenType.IMPLEMENTS_KEYWORD, JavaElementType.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        AjDeclarationParser.parsePerClause(builder);
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            error.error(JavaErrorMessages.message((String)"expected.lbrace", (Object[])new Object[0]));
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            if (elementType == AspectJElementType.ASPECT) {
                this.parseAspectBodyWithBraces(builder);
            } else {
                this.parseClassBodyWithBraces(builder, false, false);
            }
        }
        declaration.done(elementType);
        declaration.setCustomEdgeTokenBinders(JavaParserUtil.PRECEDING_COMMENT_BINDER, JavaParserUtil.TRAILING_COMMENT_BINDER);
        PsiBuilder.Marker marker = declaration;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/parsing/parser/AjDeclarationParser", "parseTypePastIdentifier"));
        }
        return marker;
    }

    private static void parsePerClause(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (PER_CLAUSE_SET.contains(tokenType)) {
            PsiBuilder.Marker perClause = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH, (String)"expected.lparen");
            if (tokenType != AspectJTokenType.ISSINGLETON_KEYWORD) {
                tokenType = builder.getTokenType();
                if (tokenType == JavaTokenType.RPARENTH || tokenType == null) {
                    builder.error(AspectJBundle.message("parser.message.pointcut.expression.expected", new Object[0]));
                } else {
                    PsiBuilder.Marker expr = builder.mark();
                    int level = 1;
                    while (!builder.eof()) {
                        tokenType = builder.getTokenType();
                        if (tokenType == JavaTokenType.LPARENTH) {
                            ++level;
                        } else if (tokenType == JavaTokenType.RPARENTH && --level == 0) break;
                        builder.advanceLexer();
                    }
                    expr.collapse(AspectJElementType.AJ_POINTCUT_EXPRESSION);
                }
            }
            JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH, (String)"expected.rparen");
            perClause.done(AspectJElementType.UNSUPPORTED);
        }
    }

    private void parseAspectBodyWithBraces(PsiBuilder builder) {
        builder.advanceLexer();
        PsiBuilder builderWrapper = JavaParserUtil.braceMatchingBuilder((PsiBuilder)builder);
        this.parseAspectBodyDeclarations(builderWrapper);
        JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACE, (String)"expected.rbrace");
    }

    private void parseAspectBodyDeclarations(PsiBuilder builder) {
        IElementType tokenType;
        PsiBuilder.Marker invalidElements = null;
        while ((tokenType = builder.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaErrorMessages.message((String)"unexpected.token", (Object[])new Object[0]));
                    invalidElements = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.parse(builder, Context.ASPECT);
            if (declaration != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaErrorMessages.message((String)"unexpected.token", (Object[])new Object[0]), declaration);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaErrorMessages.message((String)"unexpected.token", (Object[])new Object[0]));
        }
    }

    @Nullable
    private PsiBuilder.Marker parsePointcut(PsiBuilder builder, PsiBuilder.Marker declaration) {
        builder.advanceLexer();
        if (!JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER, (String)"expected.identifier")) {
            declaration.drop();
            return null;
        }
        if (builder.getTokenType() != JavaTokenType.LPARENTH) {
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.lparen", (Object[])new Object[0]));
            declaration.drop();
            return null;
        }
        this.parseParameterList(builder);
        if (builder.getTokenType() == JavaTokenType.COLON) {
            builder.advanceLexer();
            AjParserUtil.parsePointcutExpression(builder, JavaTokenType.SEMICOLON);
        }
        AjParserUtil.semicolon(builder);
        declaration.done(AspectJElementType.POINTCUT);
        return declaration;
    }

    @Nullable
    private PsiBuilder.Marker parseAdvice(PsiBuilder builder, PsiBuilder.Marker declaration) {
        PsiBuilder.Marker sp = builder.mark();
        ReferenceParser referenceParser = this.myParser.getReferenceParser();
        IElementType tokenType = builder.getTokenType();
        if ((tokenType == JavaTokenType.IDENTIFIER || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) && referenceParser.parseType(builder, 5) == null) {
            sp.rollbackTo();
            return null;
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)ADVICE_KEYWORDS_SET)) {
            sp.rollbackTo();
            return null;
        }
        sp.drop();
        if (builder.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseParameterList(builder);
        } else {
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.lparen", (Object[])new Object[0]));
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)ADVICE_ADD_KEYWORDS_SET) && builder.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseParameterList(builder);
        }
        referenceParser.parseReferenceList(builder, JavaTokenType.THROWS_KEYWORD, JavaElementType.THROWS_LIST, JavaTokenType.COMMA);
        JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.COLON, (String)"expected.colon");
        AjParserUtil.parsePointcutExpression(builder, JavaTokenType.LBRACE);
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder);
        } else {
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.lbrace", (Object[])new Object[0]));
        }
        declaration.done(AspectJElementType.ADVICE);
        return declaration;
    }

    @Nullable
    private PsiBuilder.Marker parseInterField(PsiBuilder builder, PsiBuilder.Marker declaration) {
        PsiBuilder.Marker expr;
        PsiBuilder.Marker sp;
        block4: {
            sp = builder.mark();
            if (this.myParser.getReferenceParser().parseType(builder, 5) == null || AjReferenceParser.parseInterTypeReference(builder, false) == null) {
                sp.rollbackTo();
                return null;
            }
            if (!FIELD_CLOSING_SET.contains(builder.getTokenType())) {
                CharSequence text = builder.getOriginalText();
                for (int i = builder.getCurrentOffset() - 1; i > 0; --i) {
                    char ch = text.charAt(i);
                    if (ch == ' ' || ch == '\t') continue;
                    if (ch != '\n' && ch != '\r') break;
                    break block4;
                }
                sp.rollbackTo();
                return null;
            }
        }
        sp.drop();
        AjDeclarationParser.eatBrackets(builder);
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.EQ) && (expr = this.myParser.getExpressionParser().parse(builder)) == null) {
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.expression", (Object[])new Object[0]));
        }
        AjParserUtil.semicolon(builder);
        declaration.done(AspectJElementType.INTER_TYPE_FIELD);
        declaration.setCustomEdgeTokenBinders(JavaParserUtil.PRECEDING_COMMENT_BINDER, JavaParserUtil.TRAILING_COMMENT_BINDER);
        return declaration;
    }

    @Nullable
    private PsiBuilder.Marker parseInterMethod(PsiBuilder builder, PsiBuilder.Marker declaration, PsiBuilder.Marker modList) {
        PsiBuilder.Marker sp = builder.mark();
        ReferenceParser referenceParser = this.myParser.getReferenceParser();
        referenceParser.parseTypeParameters(builder);
        if (AjReferenceParser.parseInterTypeReference(builder, true) == null) {
            if (referenceParser.parseType(builder, 5) == null || AjReferenceParser.parseInterTypeReference(builder, false) == null) {
                sp.rollbackTo();
                return null;
            }
        } else if (builder.getTokenType() != JavaTokenType.LPARENTH) {
            PsiBuilderUtil.drop((PsiBuilder.Marker[])new PsiBuilder.Marker[]{sp, declaration});
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.lparen", (Object[])new Object[0]));
            return modList;
        }
        if (builder.getTokenType() != JavaTokenType.LPARENTH) {
            sp.rollbackTo();
            return null;
        }
        sp.drop();
        this.parseParameterList(builder);
        AjDeclarationParser.eatBrackets(builder);
        referenceParser.parseReferenceList(builder, JavaTokenType.THROWS_KEYWORD, JavaElementType.THROWS_LIST, JavaTokenType.COMMA);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON)) {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                this.myParser.getStatementParser().parseCodeBlock(builder);
            } else {
                JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.lbrace.or.semicolon", (Object[])new Object[0]));
            }
        }
        declaration.done(AspectJElementType.INTER_TYPE_METHOD);
        declaration.setCustomEdgeTokenBinders(JavaParserUtil.PRECEDING_COMMENT_BINDER, JavaParserUtil.TRAILING_COMMENT_BINDER);
        return declaration;
    }

    @Nullable
    private PsiBuilder.Marker parseInterClass(PsiBuilder builder, PsiBuilder.Marker declaration) {
        PsiBuilder.Marker sp = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.CLASS_KEYWORD) || AjReferenceParser.parseInterTypeReference(builder, false) == null) {
            sp.rollbackTo();
            return null;
        }
        sp.drop();
        return this.parseTypePastIdentifier(builder, declaration, (IElementType)AspectJElementType.INTER_TYPE_CLASS);
    }

    private static boolean eatBrackets(PsiBuilder builder) {
        while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACKET)) {
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACKET)) continue;
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expected.rbracket", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static enum Context {
        FILE,
        ASPECT;

    }
}

