/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.util;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class AjFileTemplateUtil {
    private AjFileTemplateUtil() {
    }

    @NotNull
    public static PsiAspect createAspectFromTemplate(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        PsiElement element;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/aspectj/psi/util/AjFileTemplateUtil", "createAspectFromTemplate"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/aspectj/psi/util/AjFileTemplateUtil", "createAspectFromTemplate"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/lang/aspectj/psi/util/AjFileTemplateUtil", "createAspectFromTemplate"));
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)dir.getProject()).getJ2eeTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance((Project)dir.getProject()).getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", name);
        String fileName = name + "." + "aj";
        try {
            element = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)dir);
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        PsiAspectJFile file = (PsiAspectJFile)element;
        List<PsiAspect> aspects = file.getAspects();
        if (aspects.size() != 1 || !aspects.get(0).getName().equals(name)) {
            throw new IncorrectOperationException(AspectJBundle.message("action.create.aspect.bad.template", templateName));
        }
        PsiAspect psiAspect = aspects.get(0);
        if (psiAspect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/util/AjFileTemplateUtil", "createAspectFromTemplate"));
        }
        return psiAspect;
    }
}

