/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.search;

import com.intellij.lang.aspectj.index.file.InterTypeDeclarationIndex;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.util.AjPsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjScopeEnlarger
extends UseScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/search/AjScopeEnlarger", "getAdditionalUseScope"));
        }
        try {
            return AjScopeEnlarger.getScope(element);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private static SearchScope getScope(PsiElement element) {
        if (element instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)element).getOwner();
            return owner instanceof PsiClass ? AjScopeEnlarger.classScope((PsiClass)owner) : null;
        }
        if (element instanceof PsiMember && ((PsiMember)element).hasModifierProperty("private")) {
            return AjScopeEnlarger.classScope(((PsiMember)element).getContainingClass());
        }
        if (AjPsiUtil.isInjectionInsideInterType(element)) {
            return AjScopeEnlarger.injectionScope(element);
        }
        return null;
    }

    @Nullable
    private static SearchScope classScope(PsiClass psiClass) {
        Collection<VirtualFile> files;
        String name;
        if (psiClass != null && (name = psiClass.getName()) != null && !(files = InterTypeDeclarationIndex.getFilesByKey(name, psiClass.getProject())).isEmpty()) {
            return GlobalSearchScope.filesScope((Project)psiClass.getProject(), files);
        }
        return null;
    }

    @Nullable
    private static SearchScope injectionScope(PsiElement element) {
        PsiFile file;
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        PsiLanguageInjectionHost host = injectionManager.getInjectionHost(element);
        if (host != null && (file = host.getContainingFile()) instanceof PsiAspectJFile) {
            return new LocalSearchScope((PsiElement)file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void search(@NotNull PsiMember element, @NotNull Processor<PsiReference> consumer) {
        SearchScope scope;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/search/AjScopeEnlarger", "search"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/search/AjScopeEnlarger", "search"));
        }
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            scope = AjScopeEnlarger.getScope((PsiElement)element);
        }
        finally {
            token.finish();
        }
        if (scope != null) {
            ReferencesSearch.SearchParameters newParams = new ReferencesSearch.SearchParameters((PsiElement)element, scope, true);
            ReferencesSearch.search((ReferencesSearch.SearchParameters)newParams).forEach(consumer);
        }
    }
}

