/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.setup;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.plugins.api.MavenParamReferenceProvider;

public class AjMavenDependencyReferenceProvider
implements MavenParamReferenceProvider {
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull MavenDomConfiguration domCfg, @NotNull ProcessingContext context) {
        PsiElement libraryTag;
        PsiElement idTag;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/setup/AjMavenDependencyReferenceProvider", "getReferencesByElement"));
        }
        if (domCfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domCfg", "com/intellij/lang/aspectj/setup/AjMavenDependencyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/setup/AjMavenDependencyReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlText && (idTag = element.getParent()) instanceof XmlTag && (libraryTag = idTag.getParent()) instanceof XmlTag) {
            String groupId = ((XmlTag)libraryTag).getSubTagText("groupId");
            String artifactId = ((XmlTag)libraryTag).getSubTagText("artifactId");
            if (groupId != null && artifactId != null) {
                boolean inGroup = "groupId".equals(((XmlTag)idTag).getName());
                return new PsiReference[]{new MyReference(element, groupId, artifactId, inGroup)};
            }
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final String myGroupId;
        private final String myArtifactId;
        private final boolean myInGroup;

        private MyReference(PsiElement element, String groupId, String artifactId, boolean inGroup) {
            super(element);
            this.myGroupId = groupId;
            this.myArtifactId = artifactId;
            this.myInGroup = inGroup;
        }

        @Nullable
        public PsiElement resolve() {
            MavenDomDependency dependency;
            MavenDomProjectModel projectModel = (MavenDomProjectModel)MavenDomUtil.getMavenDomModel((PsiFile)this.getElement().getContainingFile(), MavenDomProjectModel.class);
            if (projectModel != null && (dependency = MavenNavigationUtil.findDependency((MavenDomProjectModel)projectModel, (String)this.myGroupId, (String)this.myArtifactId)) != null) {
                return dependency.getXmlTag();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance((Project)this.getElement().getProject());
            Object[] objectArray = this.myInGroup ? manager.getGroupIds().toArray() : manager.getArtifactIds(this.myGroupId).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/setup/AjMavenDependencyReferenceProvider$MyReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

