/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.structure;

import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.PsiInterTypeField;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.structure.nodes.InterTypeClassTreeElement;
import com.intellij.lang.aspectj.structure.nodes.InterTypeFieldTreeElement;
import com.intellij.lang.aspectj.structure.nodes.InterTypeMethodTreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import icons.AspectjIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InterTypeMembersProvider
implements FileStructureNodeProvider {
    private static final InterTypeMembersProvider INSTANCE = new InterTypeMembersProvider();
    @NonNls
    public static final String ID = "SHOW_INTER_TYPE";

    public static InterTypeMembersProvider getInstance() {
        return INSTANCE;
    }

    @NotNull
    public String getCheckBoxText() {
        String string = AspectJBundle.message("structure.view.toggle.show.inter-type", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/structure/InterTypeMembersProvider", "getCheckBoxText"));
        }
        return string;
    }

    @NotNull
    public Shortcut[] getShortcut() {
        if (Shortcut.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/structure/InterTypeMembersProvider", "getShortcut"));
        }
        return Shortcut.EMPTY_ARRAY;
    }

    @NotNull
    public Collection provideNodes(@NotNull TreeElement node) {
        PsiClass aClass;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/aspectj/structure/InterTypeMembersProvider", "provideNodes"));
        }
        if (node instanceof JavaClassTreeElement && (aClass = (PsiClass)((JavaClassTreeElement)node).getValue()).isValid() && aClass instanceof PsiAspect) {
            List<PsiInterTypeDeclaration> children = ((PsiAspect)aClass).getInterTypeDeclarations();
            ArrayList nodes = ContainerUtil.newArrayListWithCapacity((int)children.size());
            for (PsiInterTypeDeclaration child : children) {
                if (!child.isValid()) continue;
                if (child instanceof PsiInterTypeClass) {
                    nodes.add(new InterTypeClassTreeElement((PsiInterTypeClass)child));
                    continue;
                }
                if (child instanceof PsiInterTypeField) {
                    nodes.add(new InterTypeFieldTreeElement((PsiInterTypeField)child));
                    continue;
                }
                if (!(child instanceof PsiInterTypeMethod)) continue;
                nodes.add(new InterTypeMethodTreeElement((PsiInterTypeMethod)child));
            }
            ArrayList arrayList = nodes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/structure/InterTypeMembersProvider", "provideNodes"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/structure/InterTypeMembersProvider", "provideNodes"));
        }
        return list;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData(AspectJBundle.message("structure.view.action.show.inter-type", new Object[0]), null, AspectjIcons.InterTypes);
        if (actionPresentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/structure/InterTypeMembersProvider", "getPresentation"));
        }
        return actionPresentationData;
    }

    @NotNull
    public String getName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/structure/InterTypeMembersProvider", "getName"));
        }
        return ID;
    }
}

