/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.NamedDomModel;
import com.intellij.struts.StrutsDomFactory;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.WebDomFactory;
import com.intellij.struts.dom.PlugIn;
import com.intellij.struts.dom.SetProperty;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StrutsPluginDomFactory<T extends DomElement, M extends NamedDomModel<T>>
extends WebDomFactory<T, M> {
    private final String mySuperClass;
    private final String myConfigProperty;
    protected final StrutsDomFactory myStrutsFactory;

    protected StrutsPluginDomFactory(@NotNull Class<T> aClass, @NotNull String superClass, @NotNull String configProperty, @NotNull StrutsDomFactory strutsFactory, Project project, @NonNls String name) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/struts/StrutsPluginDomFactory", "<init>"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/struts/StrutsPluginDomFactory", "<init>"));
        }
        if (configProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configProperty", "com/intellij/struts/StrutsPluginDomFactory", "<init>"));
        }
        if (strutsFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strutsFactory", "com/intellij/struts/StrutsPluginDomFactory", "<init>"));
        }
        super(aClass, project, name);
        this.myStrutsFactory = strutsFactory;
        this.mySuperClass = superClass;
        this.myConfigProperty = configProperty;
    }

    @Nullable
    private PlugIn getPlugin(@NotNull StrutsModel struts) {
        if (struts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struts", "com/intellij/struts/StrutsPluginDomFactory", "getPlugin"));
        }
        PsiClass superClass = null;
        for (PlugIn plugin : ((StrutsConfig)struts.getMergedModel()).getPlugIns()) {
            PsiClass pluginClass = (PsiClass)plugin.getClassName().getValue();
            if (pluginClass == null) continue;
            if (superClass == null && (superClass = JavaPsiFacade.getInstance((Project)pluginClass.getProject()).findClass(this.mySuperClass, pluginClass.getResolveScope())) == null) {
                return null;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)pluginClass, superClass, (boolean)true)) continue;
            return plugin;
        }
        return null;
    }

    @Nullable
    public List<M> computeAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/StrutsPluginDomFactory", "computeAllModels"));
        }
        List strutsModels = this.myStrutsFactory.getAllModels((UserDataHolder)module);
        if (strutsModels.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<M> list = new ArrayList<M>(strutsModels.size());
        for (StrutsModel strutsModel : strutsModels) {
            M model = this.getModelFromStruts(strutsModel);
            if (model == null) continue;
            list.add(model);
        }
        return list;
    }

    @Nullable
    protected M getModelFromStruts(@NotNull StrutsModel strutsModel) {
        if (strutsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strutsModel", "com/intellij/struts/StrutsPluginDomFactory", "getModelFromStruts"));
        }
        PlugIn plugin = this.getPlugin(strutsModel);
        if (plugin != null) {
            LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
            XmlTag element = plugin.getXmlTag();
            assert (element != null);
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)element);
            if (webFacet == null) {
                return null;
            }
            WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil((Project)plugin.getManager().getProject());
            for (SetProperty prop : plugin.getSetProperties()) {
                String[] configPaths;
                String configString;
                String name = prop.getProperty().getStringValue();
                if (!this.myConfigProperty.equals(name) || (configString = prop.getValue().getStringValue()) == null) continue;
                for (String configPath : configPaths = configString.split(",")) {
                    PsiElement psiElement = this.resolveFile(configPath, webDirectoryUtil, webFacet);
                    if (!(psiElement instanceof XmlFile)) continue;
                    configFiles.add((XmlFile)psiElement);
                }
            }
            if (configFiles.size() > 0) {
                DomFileElement mergedModel = this.createMergedModelRoot(configFiles);
                return mergedModel == null ? null : (M)this.createModel(configFiles, mergedModel, strutsModel);
            }
        }
        return null;
    }

    protected abstract M createModel(@NotNull Set<XmlFile> var1, @NotNull DomFileElement<T> var2, StrutsModel var3);

    @Nullable
    protected PsiElement resolveFile(String path, WebDirectoryUtil webDirectoryUtil, WebFacet webFacet) {
        return webDirectoryUtil.findFileByPath(path.trim(), webFacet);
    }
}

