/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.gutter;

import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.Controller;
import com.intellij.struts.dom.FormBean;
import com.intellij.struts.dom.PlugIn;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.facet.StrutsFacet;
import com.intellij.struts.inplace.gutter.ClassAnnotator;
import com.intellij.util.xml.DomElement;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsClassAnnotator
implements Annotator {
    private final ClassAnnotator[] myClassAnnotators = new ClassAnnotator[]{new ClassAnnotator("org.apache.struts.action.Action", StrutsApiIcons.ActionMapping){

        @Override
        @Nullable
        protected DomElement[] getDestinations(PsiClass clazz) {
            ArrayList<Action> destinations = new ArrayList<Action>();
            StrutsModel model = 1.getCombinedStrutsModel(clazz);
            if (model != null) {
                for (Action action : model.getActions()) {
                    if (action.getType().getValue() != clazz) continue;
                    destinations.add(action);
                }
            }
            return destinations.isEmpty() ? null : destinations.toArray(new DomElement[destinations.size()]);
        }
    }, new ClassAnnotator("org.apache.struts.action.ActionForm", StrutsApiIcons.FormBean){

        @Override
        @Nullable
        protected DomElement[] getDestinations(PsiClass clazz) {
            ArrayList<FormBean> destinations = new ArrayList<FormBean>();
            StrutsModel model = 2.getCombinedStrutsModel(clazz);
            if (model != null) {
                for (FormBean formBean : model.getFormBeans()) {
                    if (formBean.getType().getValue() != clazz) continue;
                    destinations.add(formBean);
                }
            }
            return destinations.isEmpty() ? null : destinations.toArray(new DomElement[destinations.size()]);
        }
    }, new ClassAnnotator("org.apache.struts.action.RequestProcessor", StrutsApiIcons.Controller){

        @Override
        @Nullable
        protected DomElement[] getDestinations(PsiClass clazz) {
            Controller controller;
            PsiClass processorClazz;
            StrutsModel model = 3.getCombinedStrutsModel(clazz);
            if (model != null && (processorClazz = (PsiClass)(controller = ((StrutsConfig)model.getMergedModel()).getController()).getProcessorClass().getValue()) != null && processorClazz == clazz) {
                return new DomElement[]{controller};
            }
            return null;
        }
    }, new ClassAnnotator("org.apache.struts.action.PlugIn", AllIcons.Nodes.Plugin){

        @Override
        @Nullable
        protected DomElement[] getDestinations(PsiClass clazz) {
            ArrayList<PlugIn> destinations = new ArrayList<PlugIn>();
            StrutsModel model = 4.getCombinedStrutsModel(clazz);
            if (model != null) {
                for (PlugIn plugIn : ((StrutsConfig)model.getMergedModel()).getPlugIns()) {
                    if (plugIn.getClassName().getValue() != clazz) continue;
                    destinations.add(plugIn);
                }
            }
            return destinations.isEmpty() ? null : destinations.toArray(new DomElement[destinations.size()]);
        }
    }};

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/gutter/StrutsClassAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/struts/inplace/gutter/StrutsClassAnnotator", "annotate"));
        }
        if (psiElement instanceof PsiClass && StrutsFacet.isPresentForContainingWebFacet(psiElement)) {
            for (ClassAnnotator classAnnotator : this.myClassAnnotators) {
                if (classAnnotator.annotate((PsiClass)psiElement, holder)) break;
            }
        }
    }
}

