/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.NamedDomModel;
import com.intellij.struts.tree.MultiDomTreeStructure;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.model.impl.DomModelFactory;
import com.intellij.util.xml.tree.DomFileElementNode;
import com.intellij.util.xml.tree.DomModelTreeView;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class StrutsTreeBase<T extends DomElement, M extends NamedDomModel<T>>
extends DomModelTreeView {
    private final List<Class<? extends DomElement>> myDependencies;

    protected StrutsTreeBase(Project project, DomModelFactory<T, M, PsiElement> factory, Map<Class, Boolean> hiders, List<Class> consolidated, List<Class> folders, List<Class<? extends DomElement>> dependencies) {
        super(null, DomManager.getDomManager((Project)project), new MultiDomTreeStructure<T, M>(project, factory, hiders, consolidated, folders));
        this.myDependencies = dependencies;
    }

    protected boolean isRightFile(VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        if (psiFile == null) {
            return false;
        }
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (StrutsTreeBase.hasFile((DefaultMutableTreeNode)this.getBuilder().getTreeModel().getRoot(), xmlFile)) {
            return true;
        }
        DomManager domManager = DomManager.getDomManager((Project)this.getProject());
        for (Class<? extends DomElement> dependency : this.myDependencies) {
            if (domManager.getFileElement(xmlFile, dependency) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFile(DefaultMutableTreeNode treeNode, XmlFile file) {
        Object node = treeNode.getUserObject();
        if (node instanceof DomFileElementNode) {
            return ((DomFileElementNode)node).getDomElement().getFile() == file;
        }
        treeNode.children();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            if (!StrutsTreeBase.hasFile((DefaultMutableTreeNode)treeNode.getChildAt(i), file)) continue;
            return true;
        }
        return false;
    }

    protected boolean isRootVisible() {
        return false;
    }

    public void init() {
        if (this.getTree().getRowCount() < 2) {
            this.getTree().setRootVisible(true);
        }
        if (((DefaultMutableTreeNode)this.getTree().getModel().getRoot()).getUserObject() == null) {
            this.getBuilder().initRootNode();
        } else {
            this.getBuilder().updateFromRoot();
        }
        this.getTree().expandRow(0);
        this.getTree().setRootVisible(false);
    }
}

