/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataModelWrapper;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeMap;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeMap;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphEventManager;
import com.intellij.openapi.graph.impl.view.DefaultBackgroundRendererImpl;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.undo.UmlRefactoringElementListenerProvider;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphBuilder
extends GraphBuilderImpl<DiagramNode, DiagramEdge>
implements GraphBuilderListener,
DiagramBuilder,
DocumentListener,
CommandListener {
    public static Key<DiagramFileEditor> UML_FILE_EDITOR = Key.create((String)"UML_FILE_EDITOR");
    public static final Key<VirtualFile> EDITOR_FILE = Key.create((String)"diagram.editor.file");
    private final Map<GraphBuilderEvent, DiagramState> states = new HashMap<GraphBuilderEvent, DiagramState>();
    private boolean myPopupMode;

    protected UmlGraphBuilder(Project project, Graph2D graph, Graph2DView view, DiagramDataModel dataModel, DiagramPresentationModel presentationModel) {
        super(project, graph, view, (GraphDataModel)new DiagramDataModelWrapper(dataModel), (GraphPresentationModel)presentationModel);
        presentationModel.setGraphBuilder((GraphBuilder)this);
        this.getEventManager().subscribe((GraphBuilderListener)this);
        ((DefaultBackgroundRendererImpl)view.getBackgroundRenderer()).setColor(JBColor.background());
        if (dataModel.isPsiListener()) {
            UmlRefactoringElementListenerProvider.getInstance(project).addBuilder(this);
            DocumentAdapter documentListener = new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    VirtualFile editorFile = UmlGraphBuilder.this.getEditorFile();
                    if (editorFile != null) {
                        PsiFile psiFile = PsiDocumentManager.getInstance((Project)UmlGraphBuilder.this.getProject()).getPsiFile(e.getDocument());
                        if (!CommandProcessor.getInstance().isUndoTransparentActionInProgress() && CommandProcessor.getInstance().getCurrentCommand() != null && psiFile != null && psiFile.isValid() && UmlGraphBuilder.this.getDataModel().hasFile(psiFile) && UmlGraphBuilder.this.isDiagramEditorActive()) {
                            CommandProcessor.getInstance().addAffectedFiles(UmlGraphBuilder.this.getProject(), new VirtualFile[]{editorFile});
                        }
                    }
                }
            };
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this);
        }
    }

    private boolean isDiagramEditorActive() {
        return ArrayUtil.contains((Object)this.getEditor(), (Object[])FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditors());
    }

    public DiagramPresentationModel getGraphPresentationModel() {
        return (DiagramPresentationModel)super.getGraphPresentationModel();
    }

    public DiagramPresentationModel getPresentationModel() {
        return this.getGraphPresentationModel();
    }

    public void setAllowEdgeCreation(boolean allow) {
        this.getEditMode().allowEdgeCreation(allow);
    }

    public DiagramState getPresentation() {
        return this.getGraphPresentationModel().getPresentation();
    }

    public DiagramDataModel getDataModel() {
        return ((DiagramDataModelWrapper)this.getGraphDataModel()).getModel();
    }

    @NotNull
    public DiagramProvider getProvider() {
        DiagramProvider provider = (DiagramProvider)this.getUserData(Utils.UML_PROVIDER);
        assert (provider != null) : "Forget to add uml provider to the user data";
        DiagramProvider diagramProvider = provider;
        if (diagramProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/UmlGraphBuilder", "getProvider"));
        }
        return diagramProvider;
    }

    public void setSelected(@NotNull DiagramNode<?> node, boolean selected) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/uml/UmlGraphBuilder", "setSelected"));
        }
        Node n = this.getNode(node);
        assert (n != null) : "Node " + node.getTooltip() + " is not in the model. Or model was not updated. Call DiagramBuilder.update()";
        this.getGraph().setSelected(n, selected);
    }

    public void setSelected(@NotNull DiagramEdge<?> edge, boolean selected) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/uml/UmlGraphBuilder", "setSelected"));
        }
        Edge e = this.getEdge(edge);
        assert (e != null) : "Edge " + edge + " is not in the model. Or model was not updated. Call DiagramBuilder.update()";
        this.getGraph().setSelected(e, selected);
    }

    @Nullable
    public DiagramFileEditor getEditor() {
        return (DiagramFileEditor)this.getUserData(UML_FILE_EDITOR);
    }

    public void setEditor(DiagramFileEditor editor) {
        this.putUserData(UML_FILE_EDITOR, editor);
        editor.putUserData(Utils.GRAPH_BUILDER, (Object)this);
    }

    @Nullable
    public DocumentReference getDocumentReference() {
        VirtualFile file;
        DiagramFileEditor editor = this.getEditor();
        if (editor != null && (file = editor.getOriginalVirtualFile()) != null && file.isValid()) {
            return DocumentReferenceManager.getInstance().create(file);
        }
        return null;
    }

    public void beforeActionPerformed(GraphBuilder builder, GraphBuilderEvent event) {
        if (this == builder && !this.states.containsKey(event)) {
            this.states.put(event, new DiagramState((DiagramBuilder)this));
        }
    }

    public void actionPerformed(final GraphBuilder builder, final GraphBuilderEvent event) {
        if (this == builder && this.states.containsKey(event)) {
            new WriteCommandAction(this.getProject(), event.toString(), UmlGraphBuilder.getGroupId(event), new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/uml/UmlGraphBuilder$2", "run"));
                    }
                    DiagramActionsManager.getInstance((Project)this.getProject()).notifyUmlListeners((DiagramBuilder)((UmlGraphBuilder)builder), (DiagramState)UmlGraphBuilder.this.states.remove(event), new PsiFile[0]);
                    UmlGraphBuilder.this.notifyOtherBuilders();
                }
            }.execute();
        }
    }

    public void notifyOtherBuilders() {
        VirtualFile file = this.getEditorFile();
        if (file != null) {
            FileEditor[] editors = FileEditorManager.getInstance((Project)this.getProject()).getAllEditors(file);
            DiagramState state = new DiagramState((DiagramBuilder)this);
            ApplicationManager.getApplication().invokeLater(() -> {
                for (FileEditor editor : editors) {
                    if (!(editor instanceof UmlFileEditorImpl) || ((UmlFileEditorImpl)editor).getBuilder() == this) continue;
                    ((UmlFileEditorImpl)editor).setUmlState(state);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ((UmlFileEditorImpl)editor).getBuilder().update(false, false);
                        ((UmlFileEditorImpl)editor).getBuilder().getGraph().updateViews();
                    });
                }
            });
        }
    }

    public void commandStarted(CommandEvent event) {
    }

    public void beforeCommandFinished(CommandEvent event) {
    }

    public void commandFinished(CommandEvent event) {
    }

    public void undoTransparentActionStarted() {
    }

    public void undoTransparentActionFinished() {
    }

    @Nullable
    private static String getGroupId(GraphBuilderEvent event) {
        if (event == GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD) {
            return event.toString();
        }
        return null;
    }

    public void update() {
        this.update(true, false);
    }

    public void update(boolean increaseModTrackerCounter, boolean updateLayout) {
        if (increaseModTrackerCounter) {
            this.getGraphPresentationModel().update();
            for (DiagramEdge umlEdge : this.getEdgeObjects()) {
                Edge edge = this.getEdge(umlEdge);
                Utils.assertForgetToRemoveEdge((Edge)edge, (DiagramEdge)umlEdge, (DiagramBuilder)this);
                if (!updateLayout) continue;
                this.getGraph().getRealizer(edge).clearBends();
            }
        }
        this.updateGraph();
        if (updateLayout) {
            JBPopup popup;
            this.relayout();
            if (this.isPopupMode() && (popup = (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP)) != null) {
                GraphUtil.setBestPopupSizeForGraph((JBPopup)popup, (GraphBuilder)this);
            }
        }
    }

    public boolean isPopupMode() {
        return this.myPopupMode;
    }

    @Nullable
    public JBPopup getPopup() {
        return (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP);
    }

    public void setPopup(JBPopup popup) {
        this.putUserData(DiagramDataKeys.UML_POPUP, popup);
        this.setPopupMode(true);
    }

    public void setPopupMode(boolean popupMode) {
        this.myPopupMode = popupMode;
    }

    public void relayout() {
        NodeMap nodeMap = this.getGraphUpdateModel().getNodeUpdatesDataMap();
        EdgeMap edgeMap = this.getGraphUpdateModel().getEdgeUpdatesDataMap();
        for (Edge edge : this.getGraph().getEdgeArray()) {
            edgeMap.set((Object)edge, null);
        }
        for (Edge edge : this.getGraph().getNodeArray()) {
            nodeMap.set((Object)edge, null);
        }
        GraphSettings settings = GraphSettingsProvider.getInstance((Project)this.getProject()).getSettings((Graph)this.getGraph());
        Layouter layouter = settings.getCurrentLayouter();
        if (layouter != null) {
            layouter.doLayout((LayoutGraph)this.getGraph());
        }
        if (settings.isFitContentAfterLayout()) {
            this.getView().fitContent();
        }
    }

    public void createDraggedNode(DiagramNode node, String nodeName, Point point) {
        NodeLayout nodeLayout;
        Node nodeObj = NodeFactory.getInstance().createDraggedNode((GraphBuilder)this, (Object)node, node.getTooltip(), point);
        this.getDataModel().refreshDataModel();
        if (nodeObj != null && (nodeLayout = this.getGraph().getNodeLayout((Object)nodeObj)) != null) {
            nodeLayout.setLocation((double)point.x, (double)point.y);
        }
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
    }

    @Nullable
    public VirtualFile getEditorFile() {
        return (VirtualFile)this.getUserData(EDITOR_FILE);
    }

    public void dispose() {
        DocumentReference ref = this.getDocumentReference();
        if (ref != null) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).invalidateActionsFor(ref);
        }
        super.dispose();
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.getView().getCanvasComponent(), true);
    }

    public double zoomView(double scale) {
        return ((GraphEventManager)this.getEventManager()).zoomView(scale);
    }
}

