/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.actions.GraphActionWrapper;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.jetbrains.annotations.NotNull;

public class DeleteSelectionWrapper
extends GraphActionWrapper {
    private static final String COMMAND_NAME = "Remove selected";
    private final String groupName;

    public DeleteSelectionWrapper(AbstractAction action, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/uml/core/actions/DeleteSelectionWrapper", "<init>"));
        }
        super(action, builder);
        this.groupName = "Remove graph elements [" + builder.hashCode() + "]";
    }

    public String getID() {
        return "DeleteAction";
    }

    public void doAction(ActionEvent e) {
        DiagramBuilder builder = this.getBuilder();
        DiagramState state = new DiagramState(builder);
        List selectedNodes = this.getSelectedNodes();
        List selectedEdges = this.getSelectedEdges();
        DiagramDataModel dataModel = builder.getDataModel();
        if (selectedEdges.size() == 1 && selectedNodes.size() == 0) {
            DiagramEdge edge = builder.getEdgeObject((Edge)selectedEdges.get(0));
            if (edge != null && !(edge instanceof DiagramNoteEdge)) {
                dataModel.removeEdge(edge);
            }
            return;
        }
        Runnable deleteNodes = () -> {
            for (Node node : selectedNodes) {
                DiagramNode umlNode = builder.getNodeObject(node);
                if (umlNode == null) continue;
                DeleteSelectionWrapper.deleteNode(umlNode, dataModel);
            }
            if (!selectedNodes.isEmpty()) {
                builder.update(true, true);
                builder.updateView();
                JBPopup popup = builder.getPopup();
                if (popup != null) {
                    builder.getView().updateView();
                    DiagramUtils.setBestPopupSizeForGraph((JBPopup)popup, (DiagramBuilder)builder);
                }
            }
        };
        DiagramAction.performCommand((DiagramBuilder)builder, (Runnable)deleteNodes, (String)COMMAND_NAME, (String)this.groupName, (PsiElement[])new PsiElement[0]);
    }

    public static void deleteNode(DiagramNode umlNode, DiagramDataModel<?> dataModel) {
        if (umlNode instanceof DiagramNoteNode) {
            dataModel.removeNote((DiagramNoteNode)umlNode);
        } else {
            dataModel.removeNode(umlNode);
            Map notes = dataModel.getNotes();
            if (notes.containsKey(umlNode)) {
                dataModel.removeNote((DiagramNoteNode)notes.get(umlNode));
            }
        }
    }

    public boolean isEnabled() {
        return super.isEnabled() && DiagramNodeEditorManager.getInstance().getCurrentCellEditor() == null;
    }
}

