/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.project.ModuleDiagramEdgeCreationPolicy;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.ModulesUmlCategoryManager;
import com.intellij.uml.project.ModulesUmlColorManager;
import com.intellij.uml.project.ModulesUmlDataModel;
import com.intellij.uml.project.ModulesUmlElementManager;
import com.intellij.uml.project.ModulesUmlExtras;
import com.intellij.uml.project.ModulesUmlRelationshipManager;
import com.intellij.uml.project.ModulesUmlVfsResolver;
import com.intellij.uml.project.actions.ShowModuleCyclesAction;
import com.intellij.uml.project.actions.ShowModuleUsagesAction;
import com.intellij.uml.project.actions.ShowPathsToModuleAction;
import com.intellij.uml.utils.UmlBundle;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesUmlProvider
extends DiagramProvider<ModuleItem> {
    public static final String ID = "MODULES";
    private final DiagramVisibilityManager myVisibilityManager;
    private final ModulesUmlCategoryManager myCategoryManager;
    private final ModulesUmlElementManager myElementManager;
    private final ModulesUmlVfsResolver myVfsResolver;
    private final ModulesUmlColorManager myColorManager = new ModulesUmlColorManager();
    private final ModulesUmlRelationshipManager myRelationshipManager = new ModulesUmlRelationshipManager();
    private final ModulesUmlExtras myExtras = new ModulesUmlExtras();
    private static final DiagramNodeIntentionAction[] myIntentions = new DiagramNodeIntentionAction[]{new ShowPathsToModuleAction(), new ShowModuleCyclesAction(), new ShowModuleUsagesAction()};
    private ModuleDiagramEdgeCreationPolicy myEdgeCreationPolicy = new ModuleDiagramEdgeCreationPolicy();

    public ModulesUmlProvider() {
        this.myVisibilityManager = new EmptyDiagramVisibilityManager();
        this.myCategoryManager = new ModulesUmlCategoryManager();
        this.myElementManager = new ModulesUmlElementManager();
        this.myVfsResolver = new ModulesUmlVfsResolver();
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public ModulesUmlCategoryManager getNodeContentManager() {
        return this.myCategoryManager;
    }

    public ModulesUmlElementManager getElementManager() {
        return this.myElementManager;
    }

    public ModulesUmlVfsResolver getVfsResolver() {
        return this.myVfsResolver;
    }

    public ModulesUmlRelationshipManager getRelationshipManager() {
        return this.myRelationshipManager;
    }

    public DiagramEdgeCreationPolicy<ModuleItem> getEdgeCreationPolicy() {
        return this.myEdgeCreationPolicy;
    }

    public String getPresentableName() {
        return UmlBundle.message("modules.diagram.presentable.name", new Object[0]);
    }

    public ModulesUmlDataModel createDataModel(@NotNull Project project, @Nullable ModuleItem element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/project/ModulesUmlProvider", "createDataModel"));
        }
        return new ModulesUmlDataModel(project, element, file, presentationModel);
    }

    public DiagramColorManager getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public ModulesUmlExtras getExtras() {
        ModulesUmlExtras modulesUmlExtras = this.myExtras;
        if (modulesUmlExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/project/ModulesUmlProvider", "getExtras"));
        }
        return modulesUmlExtras;
    }

    public DiagramNodeIntentionAction<ModuleItem>[] getNodeIntentionActions() {
        return myIntentions;
    }
}

