/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.credentialStore.Credentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CredentialsDeployable
extends ServerDeployableWithTempCredentials {
    public CredentialsDeployable() {
        this(null);
    }

    public CredentialsDeployable(@Nullable RemoteCredentials data) {
        super(new WebServerConfig());
        if (data != null) {
            this.initFrom(data);
        }
    }

    private void initFrom(RemoteCredentials data) {
        this.myServer.getFileTransferConfig().setAccessType(AccessType.SFTP);
        this.myServer.getFileTransferConfig().setHost(data.getHost());
        this.myServer.getFileTransferConfig().setLiteralPort(data.getLiteralPort());
        this.myServer.getFileTransferConfig().setAnonymous(data.isAnonymous());
        this.myServer.getFileTransferConfig().setUseKeyPair(data.isUseKeyPair());
        this.myServer.getFileTransferConfig().setKnownHostsFile(data.getKnownHostsFile());
        this.myServer.getFileTransferConfig().setPrivateKeyFile(data.getPrivateKeyFile());
        this.myCredentials = data.isUseKeyPair() ? new Credentials(data.getUserName(), data.getPassphrase()) : new Credentials(data.getUserName(), data.getPassword());
    }

    public String toString() {
        return "CredentialsDeployable{myServer.name=" + this.myServer.getName() + "myServer.id=" + this.myServer.getId() + ", myCredentials=" + (this.myCredentials == null ? "null" : "***:***") + '}';
    }

    public void setName(String name) {
        this.myServer.setName(name);
    }

    public void setId(String id) {
        this.myServer.setId(id);
    }

    public void resetCredentials(@NotNull RemoteSdkCredentials credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/CredentialsDeployable", "resetCredentials"));
        }
        this.initFrom((RemoteCredentials)credentials);
    }

    public void setIsProjectLevel(boolean isProjectLevel) {
        this.myServer.setIsProjectLevel(isProjectLevel);
    }
}

