/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSshProcess;
import com.jcraft.jsch.Channel;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.Nullable;

public abstract class JschProcess
extends RemoteSshProcess {
    private static final Logger LOG = Logger.getInstance(JschProcess.class);
    protected final SshRemoteSession mySession;
    private static final long WAITFOR_TIMEOUT = 5000L;
    protected InputStream myInputStream;
    protected OutputStream myOutputStream;
    private boolean myCtrlCSent = false;
    private long myCtrlCSentMillis;

    public JschProcess(SshRemoteSession session) {
        this.mySession = session;
    }

    public abstract Channel getChannel();

    public InputStream getInputStream() {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    public SshRemoteSession getSession() {
        return this.mySession;
    }

    public boolean isDisconnected() {
        return this.getChannel().isClosed();
    }

    public int exitValue() {
        if (this.isRunning()) {
            throw new IllegalThreadStateException();
        }
        return this.getChannel().getExitStatus();
    }

    private boolean isRunning() {
        return this.getChannel().getExitStatus() < 0 && this.getChannel().isConnected();
    }

    public void destroy() {
        if (this.getChannel().isConnected()) {
            this.getChannel().disconnect();
        }
    }

    public int waitFor() throws InterruptedException {
        while (this.isRunning()) {
            Thread.sleep(100L);
            if (!this.myCtrlCSent || System.currentTimeMillis() - this.myCtrlCSentMillis <= 5000L) continue;
            LOG.warn("Remote process wasn't closed within timeout after Ctrl+C. Disconnecting.");
            this.destroy();
        }
        return this.exitValue();
    }

    public void addRemoteTunnel(int remotePort, String host, int localPort) throws RemoteSdkException {
        this.mySession.addRemoteTunnel(remotePort, host, localPort);
    }

    public void addLocalTunnel(int localPort, int remotePort) throws RemoteSdkException {
        this.mySession.addLocalTunnel(localPort, this.mySession.getHost(), remotePort);
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return this.mySession.getLocalTunnel(remotePort);
    }

    protected void setupStreams() throws IOException {
        this.getChannel().setInputStream(null);
        this.myInputStream = this.getChannel().getInputStream();
        this.myOutputStream = this.getChannel().getOutputStream();
    }

    public boolean sendCtrlC() {
        try {
            this.myOutputStream.write(3);
            this.myOutputStream.flush();
            this.myCtrlCSent = true;
            this.myCtrlCSentMillis = System.currentTimeMillis();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

