/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jetbrains.plugins.remotesdk.NullInputStream;
import com.jetbrains.plugins.remotesdk.transport.JschChannelType;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.remotesdk.transport.SshTransportException;
import java.io.IOException;
import java.io.InputStream;

public class JschShellProcess
extends JschProcess {
    private static final Logger LOG = Logger.getInstance(JschShellProcess.class);
    private final ChannelShell myChannel;

    JschShellProcess(SshRemoteSession session, int timeoutMs) throws IOException, SshTransportException {
        super(session);
        LOG.info("Creating ssh shell channel for " + session.toString());
        try {
            this.myChannel = (ChannelShell)this.mySession.openChannel(JschChannelType.SHELL);
            this.myChannel.setPty(true);
            this.myChannel.setPtyType("xterm-256color");
            this.myChannel.setEnv("LANG", "en_US.UTF-8");
            this.setupStreams();
            this.myChannel.connect(timeoutMs > 0 ? timeoutMs * 1000 : 0);
        }
        catch (JSchException e) {
            throw new SshTransportException(e.getMessage(), e);
        }
    }

    public ChannelShell getChannel() {
        return this.myChannel;
    }

    public boolean hasPty() {
        return false;
    }

    public InputStream getErrorStream() {
        return new NullInputStream();
    }
}

