/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ArrayUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jetbrains.plugins.remotesdk.ConnectionOwnerFactory;
import com.jetbrains.plugins.remotesdk.transport.JschChannelType;
import com.jetbrains.plugins.remotesdk.transport.JschExecProcess;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.JschShellProcess;
import com.jetbrains.plugins.remotesdk.transport.SshTransportException;
import com.jetbrains.plugins.remotesdk.transport.SshUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshRemoteSession {
    private static final Logger LOG = Logger.getInstance(SshRemoteSession.class);
    private Session mySession;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    private final RemoteCredentials myData;

    public SshRemoteSession(@Nullable Project project, @NotNull RemoteCredentials data) throws JSchException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "<init>"));
        }
        this(ConnectionOwnerFactory.createConnectionOwner(project), data, null);
    }

    public SshRemoteSession(@NotNull ConnectionOwner connectionOwner, RemoteCredentials data, ProgressIndicator pi) throws JSchException {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "<init>"));
        }
        this(connectionOwner, data, pi, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public SshRemoteSession(@NotNull ConnectionOwner connectionOwner, RemoteCredentials data, ProgressIndicator pi, long timeout, @NotNull TimeUnit timeUnit) throws JSchException {
        void timeUnit2;
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "<init>"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "<init>"));
        }
        this.myConnectionOwner = connectionOwner;
        this.myData = data;
        this.mySession = this.createSession(pi, timeout, (TimeUnit)timeUnit2);
        LOG.info("New ssh session created: " + this.toString());
    }

    /*
     * WARNING - void declaration
     */
    private Session createSession(@Nullable ProgressIndicator pi, long timeoutInMillis, @NotNull TimeUnit timeUnit) throws JSchException {
        void timeUnit2;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "createSession"));
        }
        return SshUtil.connectJSch(this.myData, this.myConnectionOwner, pi, timeoutInMillis, (TimeUnit)timeUnit2);
    }

    public String toString() {
        return this.mySession.getUserName() + "@" + this.mySession.getHost() + ":" + this.mySession.getPort();
    }

    public JschExecProcess exec(String command) throws IOException, SshTransportException {
        return this.exec(command, 0);
    }

    public JschExecProcess exec(String command, int timeout) throws IOException, SshTransportException {
        return this.exec(command, timeout, false);
    }

    public JschExecProcess exec(final String command, final int timeout, final boolean allocatePty) throws IOException, SshTransportException {
        return this.createJschProcess(new JschProcessFactory(){

            @Override
            public JschProcess createProcess() throws IOException, SshTransportException {
                return new JschExecProcess(SshRemoteSession.this, command, timeout, allocatePty);
            }
        }, JschExecProcess.class);
    }

    public <T extends JschProcess> T createJschProcess(JschProcessFactory factory, Class<T> clazz) throws IOException, SshTransportException {
        try {
            return (T)((Object)((JschProcess)((Object)clazz.cast((Object)factory.createProcess()))));
        }
        catch (SshTransportException e) {
            try {
                this.mySession = this.createSession(null, 60L, TimeUnit.SECONDS);
            }
            catch (JSchException e1) {
                throw new SshTransportException("Error recreating session", e);
            }
            try {
                return (T)((Object)((JschProcess)((Object)clazz.cast((Object)factory.createProcess()))));
            }
            catch (Exception e2) {
                throw new SshTransportException("Error creating a channel after session recreation");
            }
        }
    }

    public JschShellProcess shell() throws IOException, SshTransportException {
        return this.createJschProcess(new JschProcessFactory(){

            @Override
            public JschProcess createProcess() throws IOException, SshTransportException {
                return new JschShellProcess(SshRemoteSession.this, 0);
            }
        }, JschShellProcess.class);
    }

    public void disconnect() {
        if (this.mySession.isConnected()) {
            this.mySession.disconnect();
        }
    }

    public void addRemoteTunnel(int remotePort, String host, int localPort) throws RemoteSdkException {
        try {
            this.mySession.setPortForwardingR(remotePort, host, localPort);
        }
        catch (JSchException e) {
            throw new RemoteSdkException("Cant set remote tunneling", (Throwable)e);
        }
    }

    public void addLocalTunnel(int localPort, String host, int remotePort) throws RemoteSdkException {
        try {
            this.mySession.setPortForwardingL(localPort, host, remotePort);
        }
        catch (JSchException e) {
            throw new RemoteSdkException("Cant set local tunneling", (Throwable)e);
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        String[] portForwardingL = ArrayUtil.EMPTY_STRING_ARRAY;
        try {
            portForwardingL = this.mySession.getPortForwardingL();
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
        for (String portForwarding : portForwardingL) {
            int first = portForwarding.indexOf(58);
            int last = portForwarding.lastIndexOf(58);
            if (first == -1 || first == last) continue;
            try {
                int localPort = Integer.parseInt(portForwarding.substring(0, first));
                String host = portForwarding.substring(first + 1, last);
                int hostPort = Integer.parseInt(portForwarding.substring(last + 1));
                if (!host.equals(this.mySession.getHost()) || hostPort != remotePort) continue;
                return HostAndPort.fromParts((String)"127.0.0.1", (int)localPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isConnected() {
        return this.mySession.isConnected();
    }

    public ChannelSftp sftp() throws JSchException {
        return SshUtil.createSftpChannel(this.mySession);
    }

    public Channel openChannel(JschChannelType channelType) throws JSchException {
        return this.mySession.openChannel(channelType.getName());
    }

    public void delPortForwardingL(int port) throws JSchException {
        this.mySession.delPortForwardingL(port);
    }

    public String getHost() {
        return this.myData.getHost();
    }

    public String getCredentialsString() {
        return RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)this.myData);
    }

    private static interface JschProcessFactory {
        public JschProcess createProcess() throws IOException, SshTransportException;
    }
}

