/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.model.JettyConfigSetElement;
import com.intellij.javaee.oss.jetty.model.JettyWebRootElement;
import com.intellij.javaee.oss.jetty.server.JettyIntegration;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JettyUtil {
    @NonNls
    public static final String MAIN_CONFIG_PATH = "etc/jetty.xml";
    @NonNls
    public static final String JMX_CONFIG_PATH = "etc/jetty-jmx.xml";
    @NonNls
    public static final String JMX_MODULE_PATH = "modules/jmx.mod";
    @NonNls
    public static final String HTTP_CONFIG_PATH = "etc/jetty-http.xml";
    @NonNls
    private static String CONTEXT_PATH_ATTR_NAME = "contextPath";
    @NonNls
    public static final String MODULES_FOLDER_NAME = "modules";
    @NonNls
    public static final String XML_FILE_EXTENSION = ".xml";
    @NonNls
    public static final String MODULE_FILE_EXTENSION = ".mod";
    public static final FileTypeDescriptor CONFIG_FILE_DESCRIPTOR = new FileTypeDescriptor(JettyBundle.getText("JettyConfigFilesEditor.descriptor.title", new Object[0]), new String[]{".xml"});
    public static final FileTypeDescriptor MODULE_FILE_DESCRIPTOR = new FileTypeDescriptor(JettyBundle.getText("JettyConfigFilesEditor.descriptor.title", new Object[0]), new String[]{".mod"});

    private JettyUtil() {
    }

    @Nullable
    private static <T extends JavaeeDomModelElement> T getRootElement(Class<T> rootClass, @Nullable JavaeeFacet facet) {
        return (T)JettyIntegration.getInstance().getDescriptorsManager().getRootElement(rootClass, facet);
    }

    @Nullable
    public static JettyWebRootElement getWebRoot(@Nullable JavaeeFacet facet) {
        return JettyUtil.getRootElement(JettyWebRootElement.class, facet);
    }

    @Nullable
    public static String getContextRoot(@Nullable JavaeeFacet facet) {
        JettyWebRootElement web = JettyUtil.getWebRoot(facet);
        if (web == null) {
            return null;
        }
        JettyConfigSetElement contextRootElement = JettyUtil.getContextRoot(web);
        if (contextRootElement == null) {
            return null;
        }
        return (String)contextRootElement.getValue();
    }

    public static JettyConfigSetElement getOrCreateContextRoot(final JettyWebRootElement webRootElement) {
        JettyConfigSetElement contextRoot = JettyUtil.getContextRoot(webRootElement);
        if (contextRoot != null) {
            return contextRoot;
        }
        return (JettyConfigSetElement)new WriteAction<JettyConfigSetElement>(){

            protected void run(@NotNull Result<JettyConfigSetElement> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/oss/jetty/JettyUtil$1", "run"));
                }
                JettyConfigSetElement newSet = webRootElement.addSet();
                newSet.getName().setValue((Object)CONTEXT_PATH_ATTR_NAME);
                result.setResult((Object)newSet);
            }
        }.execute().getResultObject();
    }

    @Nullable
    private static JettyConfigSetElement getContextRoot(JettyWebRootElement webRootElement) {
        for (JettyConfigSetElement set : webRootElement.getSets()) {
            if (!CONTEXT_PATH_ATTR_NAME.equals(set.getName().getValue())) continue;
            return set;
        }
        return null;
    }

    public static String getModuleNameFromPath(String modulePath) {
        return FileUtil.getNameWithoutExtension((String)new File(modulePath).getName());
    }

    public static String getModuleRelativePath(String moduleName) {
        return MODULES_FOLDER_NAME + File.separator + moduleName + MODULE_FILE_EXTENSION;
    }

    public static boolean isBaseDirSupported(String version) {
        return !StringUtil.isEmpty((String)version) && new Version(version).compare(9, 1, 0) >= 0;
    }

    public static String getWorkDir(String version, String home, String base) {
        if (!JettyUtil.isBaseDirSupported(version)) {
            return home;
        }
        return StringUtil.isEmpty((String)base) ? home : base;
    }
}

