/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.UserNameRegex;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.log.HgRefManager;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(HgLogProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public HgLogProvider(@NotNull Project project, @NotNull HgRepositoryManager repositoryManager, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/log/HgLogProvider", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "org/zmlx/hg4idea/log/HgLogProvider", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/zmlx/hg4idea/log/HgLogProvider", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myRefSorter = new HgRefManager();
        this.myVcsObjectsFactory = factory;
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "readFirstBlock"));
        }
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "org/zmlx/hg4idea/log/HgLogProvider", "readFirstBlock"));
        }
        List<VcsCommitMetadata> commits = HgHistoryUtil.loadMetadata(this.myProject, root, requirements.getCommitCount(), Collections.emptyList());
        LogDataImpl logDataImpl = new LogDataImpl(this.readAllRefs(root), commits);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readFirstBlock"));
        }
        return logDataImpl;
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "readAllHashes"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "org/zmlx/hg4idea/log/HgLogProvider", "readAllHashes"));
        }
        HashSet userRegistry = ContainerUtil.newHashSet();
        List<TimedVcsCommit> commits = HgHistoryUtil.readAllHashes(this.myProject, root, (Consumer<VcsUser>)new CollectConsumer((Collection)userRegistry), Collections.emptyList());
        for (TimedVcsCommit commit : commits) {
            commitConsumer.consume((Object)commit);
        }
        LogDataImpl logDataImpl = new LogDataImpl(this.readAllRefs(root), (Set)userRegistry);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readAllHashes"));
        }
        return logDataImpl;
    }

    public void readAllFullDetails(@NotNull VirtualFile root, @NotNull Consumer<VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "readAllFullDetails"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "org/zmlx/hg4idea/log/HgLogProvider", "readAllFullDetails"));
        }
        this.readFullDetails(root, ContainerUtil.newArrayList(), commitConsumer);
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        HgVcs hgvcs = HgVcs.getInstance(this.myProject);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        HgCommandResult logResult = HgHistoryUtil.getLogResult(this.myProject, root, version, -1, HgHistoryUtil.prepareHashes(hashes), HgChangesetUtil.makeTemplate(templates));
        if (logResult == null) {
            return;
        }
        if (!logResult.getErrorLines().isEmpty()) {
            throw new VcsException(logResult.getRawError());
        }
        HgHistoryUtil.createFullCommitsFromResult(this.myProject, root, logResult, version, false).forEach(arg_0 -> commitConsumer.consume(arg_0));
    }

    @NotNull
    public List<? extends VcsShortCommitDetails> readShortDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "readShortDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "org/zmlx/hg4idea/log/HgLogProvider", "readShortDetails"));
        }
        List<? extends VcsShortCommitDetails> list = HgHistoryUtil.readMiniDetails(this.myProject, root, hashes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readShortDetails"));
        }
        return list;
    }

    @NotNull
    public List<? extends VcsFullCommitDetails> readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        List<? extends VcsFullCommitDetails> list = HgHistoryUtil.history(this.myProject, root, -1, HgHistoryUtil.prepareHashes(hashes));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        return list;
    }

    @NotNull
    private Set<VcsRef> readAllRefs(@NotNull VirtualFile root) throws VcsException {
        String tipRevision;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "readAllRefs"));
        }
        if (this.myProject.isDisposed()) {
            Set<VcsRef> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readAllRefs"));
            }
            return set;
        }
        HgRepository repository = (HgRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            Set<VcsRef> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readAllRefs"));
            }
            return set;
        }
        repository.update();
        Map<String, LinkedHashSet<Hash>> branches = repository.getBranches();
        Set<String> openedBranchNames = repository.getOpenedBranches();
        Collection<HgNameWithHashInfo> bookmarks = repository.getBookmarks();
        Collection<HgNameWithHashInfo> tags = repository.getTags();
        Collection<HgNameWithHashInfo> localTags = repository.getLocalTags();
        List<HgNameWithHashInfo> mqAppliedPatches = repository.getMQAppliedPatches();
        HashSet<VcsRef> refs = new HashSet<VcsRef>(branches.size() + bookmarks.size());
        for (Map.Entry<String, LinkedHashSet<Hash>> entry : branches.entrySet()) {
            String branchName = entry.getKey();
            boolean opened = openedBranchNames.contains(branchName);
            for (Hash hash : entry.getValue()) {
                refs.add(this.myVcsObjectsFactory.createRef(hash, branchName, opened ? HgRefManager.BRANCH : HgRefManager.CLOSED_BRANCH, root));
            }
        }
        for (HgNameWithHashInfo bookmarkInfo : bookmarks) {
            refs.add(this.myVcsObjectsFactory.createRef(bookmarkInfo.getHash(), bookmarkInfo.getName(), HgRefManager.BOOKMARK, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(currentRevision), "HEAD", HgRefManager.HEAD, root));
        }
        if ((tipRevision = repository.getTipRevision()) != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(tipRevision), "tip", HgRefManager.TIP, root));
        }
        for (HgNameWithHashInfo tagInfo : tags) {
            refs.add(this.myVcsObjectsFactory.createRef(tagInfo.getHash(), tagInfo.getName(), HgRefManager.TAG, root));
        }
        for (HgNameWithHashInfo localTagInfo : localTags) {
            refs.add(this.myVcsObjectsFactory.createRef(localTagInfo.getHash(), localTagInfo.getName(), HgRefManager.LOCAL_TAG, root));
        }
        for (HgNameWithHashInfo mqPatchRef : mqAppliedPatches) {
            refs.add(this.myVcsObjectsFactory.createRef(mqPatchRef.getHash(), mqPatchRef.getName(), HgRefManager.MQ_APPLIED_TAG, root));
        }
        HashSet<VcsRef> hashSet = refs;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readAllRefs"));
        }
        return hashSet;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = HgVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getSupportedVcs"));
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getReferenceManager"));
        }
        return vcsLogRefManager;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(final @NotNull Collection<VirtualFile> roots, final @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/zmlx/hg4idea/log/HgLogProvider", "subscribeToRootRefreshEvents"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "org/zmlx/hg4idea/log/HgLogProvider", "subscribeToRootRefreshEvents"));
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(HgVcs.STATUS_TOPIC, (Object)new HgUpdater(){

            @Override
            public void update(Project project, @Nullable VirtualFile root) {
                if (root != null && roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "subscribeToRootRefreshEvents"));
        }
        return messageBusConnection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
        }
        ArrayList filterParameters = ContainerUtil.newArrayList();
        VcsLogBranchFilter branchFilter = filterCollection.getBranchFilter();
        if (branchFilter != null) {
            HgRepository repository = (HgRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository not found for root " + root);
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
                }
                return list;
            }
            Set<String> branchNames = repository.getBranches().keySet();
            List<String> bookmarkNames = HgUtil.getNamesWithoutHashes(repository.getBookmarks());
            List predefinedNames = ContainerUtil.list((Object[])new String[]{"tip"});
            boolean atLeastOneBranchExists = false;
            for (String branchName : ContainerUtil.concat((Iterable[])new Iterable[]{branchNames, bookmarkNames, predefinedNames})) {
                if (!branchFilter.matches(branchName)) continue;
                filterParameters.add(HgHistoryUtil.prepareParameter("branch", branchName));
                atLeastOneBranchExists = true;
            }
            if (branchFilter.matches("HEAD")) {
                filterParameters.add(HgHistoryUtil.prepareParameter("branch", "."));
                filterParameters.add("-r");
                filterParameters.add("::.");
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
                }
                return list;
            }
        }
        if (filterCollection.getUserFilter() != null) {
            filterParameters.add("-r");
            String authorFilter = StringUtil.join((Collection)ContainerUtil.map((Collection)filterCollection.getUserFilter().getUserNames(root), (Function)UserNameRegex.EXTENDED_INSTANCE), (String)"|");
            filterParameters.add("user('re:" + authorFilter + "')");
        }
        if (filterCollection.getDateFilter() != null) {
            StringBuilder args = new StringBuilder();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            filterParameters.add("-d");
            VcsLogDateFilter filter = filterCollection.getDateFilter();
            if (filter.getAfter() != null) {
                if (filter.getBefore() != null) {
                    args.append(dateFormatter.format(filter.getAfter())).append(" to ").append(dateFormatter.format(filter.getBefore()));
                } else {
                    args.append('>').append(dateFormatter.format(filter.getAfter()));
                }
            } else if (filter.getBefore() != null) {
                args.append('<').append(dateFormatter.format(filter.getBefore()));
            }
            filterParameters.add(args.toString());
        }
        if (filterCollection.getTextFilter() != null) {
            String textFilter = filterCollection.getTextFilter().getText();
            if (filterCollection.getTextFilter().isRegex()) {
                filterParameters.add("-r");
                filterParameters.add("grep(r'" + textFilter + "')");
            } else if (filterCollection.getTextFilter().matchesCase()) {
                filterParameters.add("-r");
                filterParameters.add("grep(r'" + StringUtil.escapeChars((String)textFilter, (char[])UserNameRegex.EXTENDED_REGEX_CHARS) + "')");
            } else {
                filterParameters.add(HgHistoryUtil.prepareParameter("keyword", textFilter));
            }
        }
        if (filterCollection.getStructureFilter() != null) {
            for (FilePath file : filterCollection.getStructureFilter().getFiles()) {
                filterParameters.add(file.getPath());
            }
        }
        List<TimedVcsCommit> list = HgHistoryUtil.readAllHashes(this.myProject, root, (Consumer<VcsUser>)Consumer.EMPTY_CONSUMER, filterParameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
        }
        return list;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "getCurrentUser"));
        }
        String userName = HgConfig.getInstance(this.myProject, root).getNamedConfig("ui", "username");
        if (userName == null && (userName = System.getenv("HGUSER")) == null && (userName = System.getenv("USER")) == null && (userName = System.getenv("LOGNAME")) == null) {
            return null;
        }
        Couple<String> userArgs = HgUtil.parseUserNameAndEmail(userName);
        return this.myVcsObjectsFactory.createUser((String)userArgs.getFirst(), (String)userArgs.getSecond());
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "getContainingBranches"));
        }
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "org/zmlx/hg4idea/log/HgLogProvider", "getContainingBranches"));
        }
        Collection<String> collection = HgHistoryUtil.getDescendingHeadsOfBranches(this.myProject, root, commitHash);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getContainingBranches"));
        }
        return collection;
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/log/HgLogProvider", "getCurrentBranch"));
        }
        HgRepository repository = (HgRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            return null;
        }
        return repository.getCurrentBranchName();
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.CASE_INSENSITIVE_REGEX) {
            return (T)Boolean.FALSE;
        }
        return null;
    }
}

