/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.provider.HgLocalIgnoredHolder;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgIgnoredFileHolder
implements VcsIgnoredFilesHolder,
ChangesViewRefresher {
    private final Project myProject;
    private final HgVcs myVcs;
    private final Map<HgRepository, HgLocalIgnoredHolder> myVcsIgnoredHolderMap;

    public HgIgnoredFileHolder(Project project) {
        this.myProject = project;
        this.myVcs = HgVcs.getInstance(this.myProject);
        this.myVcsIgnoredHolderMap = ContainerUtil.newHashMap();
    }

    public void addFile(VirtualFile file) {
    }

    public int getDirNum() {
        return 0;
    }

    public int getFilesNum() {
        return this.myVcsIgnoredHolderMap.values().stream().mapToInt(HgLocalIgnoredHolder::getSize).sum();
    }

    public boolean containsFile(VirtualFile file) {
        HgRepository repositoryForFile = HgUtil.getRepositoryForFile(this.myProject, file);
        if (repositoryForFile == null) {
            return false;
        }
        HgLocalIgnoredHolder localIgnoredHolder = this.myVcsIgnoredHolderMap.get(repositoryForFile);
        return localIgnoredHolder != null && localIgnoredHolder.contains(file);
    }

    public Collection<VirtualFile> values() {
        return this.myVcsIgnoredHolderMap.values().stream().map(HgLocalIgnoredHolder::getIgnoredFiles).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
    }

    public void cleanAll() {
        this.myVcsIgnoredHolderMap.clear();
    }

    public FileHolder copy() {
        HgIgnoredFileHolder result = new HgIgnoredFileHolder(this.myProject);
        result.myVcsIgnoredHolderMap.putAll(this.myVcsIgnoredHolderMap);
        return result;
    }

    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.IGNORED;
    }

    public void notifyVcsStarted(AbstractVcs scope) {
        this.myVcsIgnoredHolderMap.clear();
        for (HgRepository repository : HgUtil.getRepositoryManager(this.myProject).getRepositories()) {
            this.myVcsIgnoredHolderMap.put(repository, repository.getLocalIgnoredHolder());
        }
    }

    public boolean isInUpdatingMode() {
        return this.myVcsIgnoredHolderMap.values().stream().anyMatch(HgLocalIgnoredHolder::isInUpdateMode);
    }

    @NotNull
    public AbstractVcs getVcs() {
        HgVcs hgVcs = this.myVcs;
        if (hgVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgIgnoredFileHolder", "getVcs"));
        }
        return hgVcs;
    }

    public void refresh(Project project) {
        HgUtil.getRepositoryManager(project).getRepositories().forEach(r -> r.getLocalIgnoredHolder().startRescan());
    }
}

