/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion"})
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    private static final String WHSP = "[ \\t]*";
    @NotNull
    private static final Function1<String, String> NOT_CHARS;
    @NotNull
    private static final String NONCONTROL = "(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])";
    @NotNull
    private static final String LINK_DESTINATION = "(?:<(?:\\\\[<>]|[^<>\\n])*>|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\((?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\)(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])+)";
    @NotNull
    private static final String LINK_TITLE;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> list = Companion.matchLinkDefinition(pos.getTextFromPosition());
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> matchResult = list;
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)matchResult)) {
            IElementType iElementType;
            int i = indexedValue.component1();
            IntRange range = (IntRange)indexedValue.component2();
            IntRange intRange = Companion.addToRangeAndWiden(range, pos.getOffset());
            switch (i) {
                case 0: {
                    iElementType = MarkdownElementTypes.LINK_LABEL;
                    break;
                }
                case 1: {
                    iElementType = MarkdownElementTypes.LINK_DESTINATION;
                    break;
                }
                case 2: {
                    iElementType = MarkdownElementTypes.LINK_TITLE;
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)"There are no more than three groups in this regex"));
                }
            }
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(intRange, iElementType)));
        }
        int matchLength = ((IntRange)CollectionsKt.last(matchResult)).getEndInclusive() + 1;
        LookaheadText.Position endPosition = pos.nextPosition(matchLength);
        if (endPosition != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }

    static {
        Companion = new Companion(null);
        WHSP = WHSP;
        NOT_CHARS = Companion.NOT_CHARS.1.INSTANCE;
        NONCONTROL = NONCONTROL;
        LINK_DESTINATION = "(?:<(?:" + "\\" + "\\" + "[<>]|[^<>" + "\\" + "n])*>|" + Companion.getNONCONTROL() + "*" + "\\" + "(" + Companion.getNONCONTROL() + "*" + "\\" + ")" + Companion.getNONCONTROL() + "*|" + Companion.getNONCONTROL() + "+)";
        LINK_TITLE = "(?:" + "\"" + (String)Companion.getNOT_CHARS().invoke((Object)"\"") + "\"" + "|'" + (String)Companion.getNOT_CHARS().invoke((Object)"'") + "'|" + "\\" + "(" + (String)Companion.getNOT_CHARS().invoke((Object)"\\)") + "\\" + "))";
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u001aJ\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0015J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "()V", "LINK_DESTINATION", "", "getLINK_DESTINATION", "()Ljava/lang/String;", "LINK_TITLE", "getLINK_TITLE", "NONCONTROL", "getNONCONTROL", "NOT_CHARS", "Lkotlin/Function1;", "getNOT_CHARS", "()Lkotlin/jvm/functions/Function1;", "WHSP", "getWHSP", "addToRangeAndWiden", "Lkotlin/ranges/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "matchLinkDefinition", "", "text", "", "matchLinkLabel", "start", "passOneNewline"})
    public static final class Companion {
        @NotNull
        public final String getWHSP() {
            return WHSP;
        }

        @NotNull
        public final Function1<String, String> getNOT_CHARS() {
            return NOT_CHARS;
        }

        @NotNull
        public final String getNONCONTROL() {
            return NONCONTROL;
        }

        @NotNull
        public final String getLINK_DESTINATION() {
            return LINK_DESTINATION;
        }

        @NotNull
        public final String getLINK_TITLE() {
            return LINK_TITLE;
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return new IntRange(range.getStart() + t, range.getEndInclusive() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<IntRange> matchLinkDefinition(@NotNull CharSequence text) {
            void offset;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            int n = 3;
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                do {
                    int it = ++n2;
                    if (offset.element >= text.length() || text.charAt(offset.element) != ' ') continue;
                    int n4 = offset.element;
                    offset.element = n4 + 1;
                } while (n2 != n3);
            }
            IntRange intRange = this.matchLinkLabel(text, offset.element);
            if (intRange == null) {
                return null;
            }
            IntRange linkLabel = intRange;
            offset.element = linkLabel.getEndInclusive() + 1;
            if (offset.element >= text.length() || text.charAt(offset.element) != ':') {
                return null;
            }
            n2 = offset.element;
            offset.element = n2 + 1;
            offset.element = this.passOneNewline(text, offset.element);
            MatchResult matchResult = Regex.find$default((Regex)new Regex("^" + this.getLINK_DESTINATION()), (CharSequence)text.subSequence(offset.element, text.length()), (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult destination = matchResult;
            IntRange destinationRange = new IntRange(destination.getRange().getStart() + offset.element, destination.getRange().getEndInclusive() + offset.element);
            offset.element += destination.getRange().getEndInclusive() - destination.getRange().getStart() + 1;
            offset.element = this.passOneNewline(text, offset.element);
            MatchResult title = Regex.find$default((Regex)new Regex("^" + this.getLINK_TITLE()), (CharSequence)text.subSequence(offset.element, text.length()), (int)0, (int)2, null);
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            result.add(linkLabel);
            result.add(destinationRange);
            if (title != null) {
                IntRange titleRange = new IntRange(title.getRange().getStart() + offset.element, title.getRange().getEndInclusive() + offset.element);
                offset.element += title.getRange().getEndInclusive() - title.getRange().getStart() + 1;
                while (offset.element < text.length()) {
                    int n5 = text.charAt(offset.element);
                    int it = n5;
                    if (!(it == 32 || it == 9)) break;
                    n5 = offset.element;
                    offset.element = n5 + 1;
                }
                if (offset.element >= text.length() || text.charAt(offset.element) == '\n') {
                    result.add(titleRange);
                }
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final IntRange matchLinkLabel(@NotNull CharSequence text, int start) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int offset = start;
            if (offset >= text.length() || text.charAt(offset) != '[') {
                return null;
            }
            ++offset;
            boolean seenNonWhitespace = false;
            int n = 1;
            int n2 = 999;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (offset >= text.length()) {
                        return null;
                    }
                    char c = text.charAt(offset);
                    if (c == '[' || c == ']') break;
                    if (c == '\\') {
                        if (++offset >= text.length()) {
                            return null;
                        }
                        c = text.charAt(offset);
                    }
                    if (!CharsKt.isWhitespace((char)c)) {
                        seenNonWhitespace = true;
                    }
                    ++offset;
                    if (i == n2) break;
                    ++i;
                }
            }
            if (!seenNonWhitespace || offset >= text.length() || text.charAt(offset) != ']') {
                return null;
            }
            return new IntRange(start, offset);
        }

        private final int passOneNewline(CharSequence text, int start) {
            char it;
            char c;
            int offset;
            for (offset = start; offset < text.length(); ++offset) {
                c = text.charAt(offset);
                it = c;
                if (!(it == ' ' || it == '\t')) break;
            }
            if (offset < text.length() && text.charAt(offset) == '\n') {
                ++offset;
                while (offset < text.length()) {
                    c = text.charAt(offset);
                    it = c;
                    if (!(it == ' ' || it == '\t')) break;
                    ++offset;
                }
            }
            return offset;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

