/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.edges;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.diagram.edges.CdiDependencyType;
import com.intellij.cdi.diagram.edges.CdiDiagramEdge;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;

public class CdiProducerEdge
extends CdiDiagramEdge {
    private PsiMember myPsiMember;

    public CdiProducerEdge(DiagramNode<CdiBeanDescriptor> source, DiagramNode<CdiBeanDescriptor> target, PsiMember psiMember) {
        super(source, target, CdiDependencyType.PRODUCES, (DiagramRelationshipInfo)CdiProducerEdge.getInfo(psiMember));
        this.myPsiMember = psiMember;
    }

    @NotNull
    private static DiagramRelationshipInfoAdapter getInfo(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/cdi/diagram/edges/CdiProducerEdge", "getInfo"));
        }
        String name = CdiProducerEdge.getQualifierAnnotationsAsHtml(CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)member));
        DiagramRelationshipInfoAdapter diagramRelationshipInfoAdapter = new DiagramRelationshipInfoAdapter(name, DiagramLineType.DASHED, name){

            public Shape getStartArrow() {
                return DELTA;
            }
        };
        if (diagramRelationshipInfoAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/diagram/edges/CdiProducerEdge", "getInfo"));
        }
        return diagramRelationshipInfoAdapter;
    }

    public PsiMember getPsiMember() {
        return this.myPsiMember;
    }

    public Object getTargetAnchor() {
        return this.myPsiMember;
    }

    public Object getSourceAnchor() {
        return this.myPsiMember;
    }

    public String getName() {
        return CdiProducerEdge.getQualifierAnnotationsAsHtml(CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)this.myPsiMember));
    }
}

