/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.CheckinParameters;
import org.jetbrains.tfsIntegration.core.TFSAnnotationProvider;
import org.jetbrains.tfsIntegration.core.TFSChangeList;
import org.jetbrains.tfsIntegration.core.TFSChangeProvider;
import org.jetbrains.tfsIntegration.core.TFSCheckinEnvironment;
import org.jetbrains.tfsIntegration.core.TFSCheckoutProvider;
import org.jetbrains.tfsIntegration.core.TFSCommittedChangesProvider;
import org.jetbrains.tfsIntegration.core.TFSDiffProvider;
import org.jetbrains.tfsIntegration.core.TFSEditFileProvider;
import org.jetbrains.tfsIntegration.core.TFSFileListener;
import org.jetbrains.tfsIntegration.core.TFSHistoryProvider;
import org.jetbrains.tfsIntegration.core.TFSProjectConfigurable;
import org.jetbrains.tfsIntegration.core.TFSRollbackEnvironment;
import org.jetbrains.tfsIntegration.core.TFSUpdateEnvironment;
import org.jetbrains.tfsIntegration.core.TfsSdkManager;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;

public class TFSVcs
extends AbstractVcs {
    @NonNls
    public static final String TFS_NAME = "TFS";
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.tfsIntegration.core.TFSVcs");
    private static final VcsKey ourKey = TFSVcs.createKey((String)"TFS");
    private VcsVFSListener myFileListener;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private final VcsShowSettingOption myCheckoutOptions;
    private CommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> myCommittedChangesProvider;
    private VcsHistoryProvider myHistoryProvider;
    private DiffProvider myDiffProvider;
    private TFSCheckinEnvironment myCheckinEnvironment;
    private UpdateEnvironment myUpdateEnvironment;
    private AnnotationProvider myAnnotationProvider;
    private final List<RevisionChangedListener> myRevisionChangedListeners;
    private final CheckinData myCheckinData;

    public TFSVcs(@NotNull Project project, UltimateVerifier verifier) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/core/TFSVcs", "<init>"));
        }
        super(project, TFS_NAME);
        this.myRevisionChangedListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCheckinData = new CheckinData();
        PluginVerifier.verifyUltimatePlugin(verifier);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
    }

    public CheckinData getCheckinData() {
        return this.myCheckinData;
    }

    public static TFSVcs getInstance(Project project) {
        return (TFSVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(TFS_NAME);
    }

    @NonNls
    public String getDisplayName() {
        return TFS_NAME;
    }

    public Configurable getConfigurable() {
        return new TFSProjectConfigurable(this.myProject);
    }

    public void activate() {
        this.myFileListener = new TFSFileListener(this.getProject(), this);
        TfsSdkManager.activate();
    }

    public void deactivate() {
        Disposer.dispose((Disposable)this.myFileListener);
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public ChangeProvider getChangeProvider() {
        return new TFSChangeProvider(this.myProject);
    }

    @NotNull
    public TFSCheckinEnvironment createCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new TFSCheckinEnvironment(this);
        }
        TFSCheckinEnvironment tFSCheckinEnvironment = this.myCheckinEnvironment;
        if (tFSCheckinEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSVcs", "createCheckinEnvironment"));
        }
        return tFSCheckinEnvironment;
    }

    public RollbackEnvironment createRollbackEnvironment() {
        return new TFSRollbackEnvironment(this.myProject);
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        return this.isVersionedDirectory(filePath.getVirtualFile());
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        if (dir == null) {
            return false;
        }
        return !Workstation.getInstance().findWorkspacesCached(TfsFileUtil.getFilePath(dir), false).isEmpty();
    }

    public EditFileProvider getEditFileProvider() {
        return new TFSEditFileProvider(this.myProject);
    }

    public UpdateEnvironment createUpdateEnvironment() {
        if (this.myUpdateEnvironment == null) {
            this.myUpdateEnvironment = new TFSUpdateEnvironment(this);
        }
        return this.myUpdateEnvironment;
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new TFSAnnotationProvider(this);
        }
        return this.myAnnotationProvider;
    }

    public static void assertTrue(boolean condition, @NonNls String message) {
        LOG.assertTrue(condition, (Object)message);
        if (!condition) {
            TFSVcs.error(message);
        }
    }

    public static void error(@NonNls String message) {
        LOG.error(message);
        throw new RuntimeException("Assertion failed: " + message);
    }

    public static void assertTrue(boolean condition) {
        TFSVcs.assertTrue(condition, "");
    }

    @NotNull
    public CommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new TFSCommittedChangesProvider(this.myProject);
        }
        CommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> committedChangesProvider = this.myCommittedChangesProvider;
        if (committedChangesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSVcs", "getCommittedChangesProvider"));
        }
        return committedChangesProvider;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        if (this.myHistoryProvider == null) {
            this.myHistoryProvider = new TFSHistoryProvider(this.myProject);
        }
        return this.myHistoryProvider;
    }

    public DiffProvider getDiffProvider() {
        if (this.myDiffProvider == null) {
            this.myDiffProvider = new TFSDiffProvider(this.myProject);
        }
        return this.myDiffProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return TfsRevisionNumber.tryParse(revisionNumberString);
    }

    @Nullable
    public String getRevisionPattern() {
        return "\\d+";
    }

    public void fireRevisionChanged() {
        for (RevisionChangedListener listener : this.myRevisionChangedListeners) {
            listener.revisionChanged();
        }
    }

    public void addRevisionChangedListener(RevisionChangedListener listener) {
        this.myRevisionChangedListeners.add(listener);
    }

    public void removeRevisionChangedListener(RevisionChangedListener listener) {
        this.myRevisionChangedListeners.remove(listener);
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public static boolean isUnderTFS(FilePath path, Project project) {
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)path);
        return vcs != null && TFS_NAME.equals(vcs.getName());
    }

    public CheckoutProvider getCheckoutProvider() {
        return new TFSCheckoutProvider();
    }

    public static class CheckinData {
        public CheckinParameters parameters;
        JLabel messageLabel;
    }

    public static interface RevisionChangedListener {
        public void revisionChanged();
    }
}

