/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.configuration;

import com.intellij.notification.Notification;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;

@Tag(value="configuration")
public class ServerConfiguration {
    @Nullable
    private Credentials myCredentials;
    @Nullable
    private String myProxyUri;
    private boolean myProxyInaccessible;
    private Notification myAuthCanceledNotification;

    public ServerConfiguration() {
    }

    public ServerConfiguration(Credentials credentials) {
        this.myCredentials = credentials;
    }

    @Tag(value="credentials")
    @Nullable
    public Credentials getCredentials() {
        return this.myCredentials;
    }

    public void setCredentials(@NotNull Credentials credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "org/jetbrains/tfsIntegration/core/configuration/ServerConfiguration", "setCredentials"));
        }
        this.myCredentials = credentials;
    }

    @Tag(value="proxy")
    @Nullable
    public String getProxyUri() {
        return this.myProxyUri;
    }

    public void setProxyUri(@Nullable String proxyUri) {
        if (!Comparing.equal((String)this.myProxyUri, (String)proxyUri)) {
            this.myProxyInaccessible = false;
        }
        this.myProxyUri = proxyUri;
    }

    @Transient
    public boolean isProxyInaccessible() {
        return this.myProxyInaccessible;
    }

    public void setProxyInaccessible() {
        this.myProxyInaccessible = true;
    }

    @Transient
    public Notification getAuthCanceledNotification() {
        return this.myAuthCanceledNotification;
    }

    public void setAuthCanceledNotification(Notification authCanceledNotification) {
        this.myAuthCanceledNotification = authCanceledNotification;
    }
}

