/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;

public class WorkingFolderInfo {
    @NotNull
    private FilePath myLocalPath;
    @NotNull
    private String myServerPath;
    @NotNull
    private Status myStatus;

    public WorkingFolderInfo(FilePath localPath) {
        this(Status.Active, localPath, "");
    }

    public WorkingFolderInfo(@NotNull Status status, @NotNull FilePath localPath, @NotNull String serverPath) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "<init>"));
        }
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "<init>"));
        }
        if (serverPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverPath", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "<init>"));
        }
        this.myStatus = status;
        this.myLocalPath = localPath;
        this.myServerPath = serverPath;
    }

    @NotNull
    public FilePath getLocalPath() {
        FilePath filePath = this.myLocalPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "getLocalPath"));
        }
        return filePath;
    }

    @NotNull
    public String getServerPath() {
        String string = this.myServerPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "getServerPath"));
        }
        return string;
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "getStatus"));
        }
        return status;
    }

    public void setStatus(@NotNull Status status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "setStatus"));
        }
        this.myStatus = status;
    }

    public void setServerPath(@NotNull String serverPath) {
        if (serverPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverPath", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "setServerPath"));
        }
        this.myServerPath = serverPath;
    }

    public void setLocalPath(@NotNull FilePath localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "setLocalPath"));
        }
        this.myLocalPath = localPath;
    }

    public WorkingFolderInfo getCopy() {
        return new WorkingFolderInfo(this.myStatus, this.myLocalPath, this.myServerPath);
    }

    @Nullable
    String getServerPathByLocalPath(@NotNull FilePath localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo", "getServerPathByLocalPath"));
        }
        if (!StringUtil.isEmpty((String)this.getServerPath()) && localPath.isUnder(this.getLocalPath(), false)) {
            return VersionControlPath.getCombinedServerPath(this.getLocalPath(), this.getServerPath(), localPath);
        }
        return null;
    }

    @Nullable
    public FilePath getLocalPathByServerPath(String serverPath, boolean isDirectory) {
        if (!StringUtil.isEmpty((String)this.getServerPath()) && VersionControlPath.isUnder(this.getServerPath(), serverPath)) {
            return VersionControlPath.getCombinedLocalPath(this.getLocalPath(), this.getServerPath(), serverPath, isDirectory);
        }
        return null;
    }

    public static enum Status {
        Active,
        Cloaked;

    }
}

