/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.labels;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionSpec;
import org.jetbrains.annotations.NotNull;

public class ItemAndVersion {
    private final Item myItem;
    private final VersionSpec myVersionSpec;

    public ItemAndVersion(@NotNull Item item, @NotNull VersionSpec versionSpec) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/labels/ItemAndVersion", "<init>"));
        }
        if (versionSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionSpec", "org/jetbrains/tfsIntegration/core/tfs/labels/ItemAndVersion", "<init>"));
        }
        this.myItem = item;
        this.myVersionSpec = versionSpec;
    }

    public Item getItem() {
        return this.myItem;
    }

    public VersionSpec getVersionSpec() {
        return this.myVersionSpec;
    }

    public String getServerPath() {
        return this.myItem.getItem();
    }

    public boolean isDirectory() {
        return this.myItem.getType() == ItemType.Folder;
    }
}

