/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public abstract class MultiLineTableRenderer
extends JTextArea
implements TableCellRenderer {
    public MultiLineTableRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setBorder(UIManager.getBorder("Table.cellNoFocusBorder"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            Color alternateColor;
            Color background = table.getBackground();
            if ((background == null || background instanceof UIResource) && (alternateColor = UIManager.getColor("Table.alternateRowColor")) != null && row % 2 == 0) {
                background = alternateColor;
            }
            super.setForeground(table.getForeground());
            super.setBackground(background);
        }
        this.setFont(table.getFont());
        if (hasFocus && !isSelected && table.isCellEditable(row, column)) {
            Color col = UIUtil.getTableFocusCellForeground();
            if (col != null) {
                super.setForeground(col);
            }
            if ((col = UIUtil.getTableFocusCellBackground()) != null) {
                super.setBackground(col);
            }
        }
        this.customize(table, this, isSelected, value);
        this.setSize(table.getColumnModel().getColumn(column).getWidth(), 100000);
        table.setRowHeight(row, this.getPreferredSize().height);
        return this;
    }

    protected abstract void customize(JTable var1, JTextArea var2, boolean var3, Object var4);
}

