/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.TfsExecutionUtil;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemsQuery;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.BaseQueryNode;
import org.jetbrains.tfsIntegration.ui.QueriesTreeContext;
import org.jetbrains.tfsIntegration.ui.WorkItemsQueryResult;

public class PredefinedQueryNode
extends BaseQueryNode {
    @NotNull
    private final WorkItemsQuery myQuery;

    public PredefinedQueryNode(@NotNull QueriesTreeContext context, @NotNull WorkItemsQuery query) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/tfsIntegration/ui/PredefinedQueryNode", "<init>"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "org/jetbrains/tfsIntegration/ui/PredefinedQueryNode", "<init>"));
        }
        super(context);
        this.myQuery = query;
    }

    protected void doUpdate() {
        PresentationData presentation = this.getPresentation();
        presentation.addText(this.myQuery.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myQuery};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/PredefinedQueryNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    public SimpleNode[] getChildren() {
        return NO_CHILDREN;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public void handleSelection(final @NotNull SimpleTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/tfsIntegration/ui/PredefinedQueryNode", "handleSelection"));
        }
        this.myQueriesTreeContext.queryWorkItems(new TfsExecutionUtil.Process<WorkItemsQueryResult>(){

            @Override
            @NotNull
            public WorkItemsQueryResult run() throws TfsException, VcsException {
                WorkItemsQueryResult workItemsQueryResult = new WorkItemsQueryResult(PredefinedQueryNode.this.myQuery.queryWorkItems(PredefinedQueryNode.this.getServer(), tree, null));
                if (workItemsQueryResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/PredefinedQueryNode$1", "run"));
                }
                return workItemsQueryResult;
            }
        });
    }
}

