/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.text.MessageFormat;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;

public class ProxySettingsForm {
    private JPanel myContentPane;
    private JRadioButton myNoProxyRadioButton;
    private JRadioButton myProxyServerRadioButton;
    private JTextField myProxyServerTextField;
    private JLabel myMessageLabel;
    private JLabel myInfoLabel;
    private JLabel myProxyUrlLabel;
    private final EventDispatcher<Listener> myEventDispatcher;

    public ProxySettingsForm(@Nullable URI initialProxyUri, @Nullable String serverQualifiedUsername) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        if (initialProxyUri == null) {
            this.myNoProxyRadioButton.setSelected(true);
        } else {
            this.myProxyServerRadioButton.setSelected(true);
            this.myProxyServerTextField.setText(initialProxyUri.toString());
        }
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsForm.this.updateContols();
                ((Listener)ProxySettingsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        };
        this.myNoProxyRadioButton.addActionListener(radioButtonListener);
        this.myProxyServerRadioButton.addActionListener(radioButtonListener);
        this.myProxyServerTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((Listener)ProxySettingsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        });
        String infoMessage = MessageFormat.format("Credentials to connect to the proxy: {0}", serverQualifiedUsername != null ? serverQualifiedUsername : "(not specified)");
        this.myInfoLabel.setText(infoMessage);
        this.updateContols();
    }

    private void updateContols() {
        this.myProxyServerTextField.setEnabled(this.myProxyServerRadioButton.isSelected());
        this.myInfoLabel.setEnabled(this.myProxyServerRadioButton.isSelected());
        this.myProxyUrlLabel.setEnabled(this.myProxyServerRadioButton.isSelected());
        if (this.myProxyServerRadioButton.isSelected()) {
            this.myProxyServerTextField.requestFocus();
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public boolean isValid() {
        return this.myNoProxyRadioButton.isSelected() || TfsUtil.getUrl(this.myProxyServerTextField.getText(), true, true) != null;
    }

    @Nullable
    public URI getProxyUri() {
        if (this.myNoProxyRadioButton.isSelected()) {
            return null;
        }
        return TfsUtil.getUrl(this.myProxyServerTextField.getText(), true, true);
    }

    public void setMessage(@Nullable String message) {
        this.myMessageLabel.setText(message);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JLabel jLabel3;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myProxyServerTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProxyUrlLabel = jLabel3 = new JLabel();
        jLabel3.setText("Address:");
        jLabel3.setDisplayedMnemonic('A');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myProxyServerRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Use TFS proxy");
        jRadioButton2.setMnemonic('U');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myNoProxyRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Connect to server directly");
        jRadioButton.setMnemonic('C');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMessageLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setForeground(new Color(-65536));
        jLabel2.setText(" ");
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, new Dimension(300, -1), null, null));
        this.myInfoLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Listener
    extends EventListener {
        public void stateChanged();
    }
}

