/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.microsoft.tfs.core.clients.workitem.WorkItemQueryUtils;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameter;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameterCollection;
import com.microsoft.tfs.core.clients.workitem.query.Query;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemLinkInfo;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryType;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.TfsExecutionUtil;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemField;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemSerialize;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.BaseQueryNode;
import org.jetbrains.tfsIntegration.ui.QueriesTreeContext;
import org.jetbrains.tfsIntegration.ui.WorkItemsQueryResult;

public class SavedQueryDefinitionNode
extends BaseQueryNode {
    private static String[] WORK_ITEM_FIELDS = (String[])ContainerUtil.map2Array(WorkItemSerialize.FIELDS, String.class, (Function)new Function<WorkItemField, String>(){

        public String fun(@NotNull WorkItemField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode$1", "fun"));
            }
            return field.getSerialized();
        }
    });
    private static String WORK_ITEMS_QUERY = "SELECT " + WorkItemQueryUtils.formatFieldList((String[])WORK_ITEM_FIELDS) + " FROM WorkItems";
    @NotNull
    private final QueryDefinition myQueryDefinition;

    public SavedQueryDefinitionNode(@NotNull QueriesTreeContext context, @NotNull QueryDefinition definition) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "<init>"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "<init>"));
        }
        super(context);
        this.myQueryDefinition = definition;
    }

    protected void doUpdate() {
        PresentationData presentation = this.getPresentation();
        presentation.addText(this.myQueryDefinition.getName(), this.getPlainAttributes());
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myQueryDefinition.getID()};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    public SimpleNode[] getChildren() {
        return NO_CHILDREN;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public void handleSelection(@NotNull SimpleTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "handleSelection"));
        }
        final boolean isList = this.isListQuery();
        this.myQueriesTreeContext.queryWorkItems(new TfsExecutionUtil.Process<WorkItemsQueryResult>(){

            @Override
            @NotNull
            public WorkItemsQueryResult run() throws TfsException, VcsException {
                WorkItemsQueryResult workItemsQueryResult;
                try {
                    workItemsQueryResult = isList ? SavedQueryDefinitionNode.this.runListQuery() : SavedQueryDefinitionNode.this.runLinkQuery();
                }
                catch (WorkItemException e) {
                    throw new VcsException((Throwable)e);
                }
                catch (ProxyException e) {
                    throw new VcsException((Throwable)e);
                }
                if (workItemsQueryResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode$2", "run"));
                }
                return workItemsQueryResult;
            }
        });
    }

    private boolean isListQuery() {
        return QueryType.LIST.equals((Object)this.myQueryDefinition.getQueryType());
    }

    @NotNull
    private WorkItemsQueryResult runListQuery() throws WorkItemException, ProxyException {
        WorkItemCollection workItems = this.getWorkItemClient().query(this.myQueryDefinition.getQueryText(), this.buildQueryContext());
        WorkItemsQueryResult workItemsQueryResult = new WorkItemsQueryResult(SavedQueryDefinitionNode.toList(workItems));
        if (workItemsQueryResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "runListQuery"));
        }
        return workItemsQueryResult;
    }

    @NotNull
    private static List<WorkItem> toList(@NotNull WorkItemCollection workItems) throws WorkItemException, ProxyException {
        if (workItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItems", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "toList"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (int i = 0; i < workItems.size(); ++i) {
            result.add(WorkItem.create(workItems.getWorkItem(i)));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "toList"));
        }
        return arrayList;
    }

    @NotNull
    private WorkItemsQueryResult runLinkQuery() throws WorkItemException, ProxyException {
        Query linksQuery = this.getWorkItemClient().createQuery(this.myQueryDefinition.getQueryText(), this.buildQueryContext());
        ArrayList links = ContainerUtil.newArrayList((Object[])linksQuery.runLinkQuery());
        Query workItemsQuery = this.getWorkItemClient().createQuery(WORK_ITEMS_QUERY, SavedQueryDefinitionNode.toBatchReadCollection(SavedQueryDefinitionNode.getWorkItemIds(links)));
        WorkItemsQueryResult workItemsQueryResult = new WorkItemsQueryResult(SavedQueryDefinitionNode.toList(workItemsQuery.runQuery()), links);
        if (workItemsQueryResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "runLinkQuery"));
        }
        return workItemsQueryResult;
    }

    @NotNull
    private static BatchReadParameterCollection toBatchReadCollection(@NotNull Iterable<Integer> ids) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "toBatchReadCollection"));
        }
        BatchReadParameterCollection result = new BatchReadParameterCollection();
        for (Integer id : ids) {
            result.add(new BatchReadParameter(id.intValue()));
        }
        BatchReadParameterCollection batchReadParameterCollection = result;
        if (batchReadParameterCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "toBatchReadCollection"));
        }
        return batchReadParameterCollection;
    }

    @NotNull
    private static Set<Integer> getWorkItemIds(@NotNull Iterable<WorkItemLinkInfo> links) {
        if (links == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "links", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "getWorkItemIds"));
        }
        HashSet result = ContainerUtil.newHashSet();
        for (WorkItemLinkInfo link : links) {
            SavedQueryDefinitionNode.addId(result, link.getSourceID());
            SavedQueryDefinitionNode.addId(result, link.getTargetID());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "getWorkItemIds"));
        }
        return hashSet;
    }

    private static void addId(@NotNull Set<Integer> ids, int id) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "addId"));
        }
        if (id > 0) {
            ids.add(id);
        }
    }

    @NotNull
    private Map<String, Object> buildQueryContext() {
        Map map = WorkItemQueryUtils.makeContext((Project)this.myQueryDefinition.getProject(), null);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode", "buildQueryContext"));
        }
        return map;
    }
}

