/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.servertree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import icons.TFSIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.servertree.TfsErrorTreeNode;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeContext;

public class TfsTreeNode
extends SimpleNode {
    private static final SimpleTextAttributes VIRTUAL_ATTRS = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
    private final TfsTreeContext myTreeContext;
    private final String myPath;
    private final boolean myIsDirectory;
    private final boolean myVirtual;
    private final Collection<TfsTreeNode> myVirtualChildren;

    public TfsTreeNode(@NotNull Object projectOrComponent, ServerInfo server, boolean foldersOnly, @Nullable Condition<String> pathFilter) {
        if (projectOrComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectOrComponent", "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeNode", "<init>"));
        }
        super(projectOrComponent instanceof Project ? (Project)projectOrComponent : null);
        this.myVirtualChildren = new ArrayList<TfsTreeNode>();
        this.myTreeContext = new TfsTreeContext(server, foldersOnly, projectOrComponent, pathFilter);
        this.myPath = "$/";
        this.myIsDirectory = true;
        this.myVirtual = false;
    }

    private TfsTreeNode(TfsTreeNode parent, String path, boolean isDirectory, boolean virtual) {
        super((SimpleNode)parent);
        this.myVirtualChildren = new ArrayList<TfsTreeNode>();
        this.myPath = path;
        this.myIsDirectory = isDirectory;
        this.myVirtual = virtual;
        this.myTreeContext = parent.myTreeContext;
    }

    public SimpleNode[] getChildren() {
        List<Item> children;
        if (!this.myIsDirectory) {
            return NO_CHILDREN;
        }
        try {
            children = this.myTreeContext.getChildItems(this.myPath);
        }
        catch (TfsException e) {
            return new SimpleNode[]{new TfsErrorTreeNode(this, e.getMessage())};
        }
        ArrayList<TfsTreeNode> result = new ArrayList<TfsTreeNode>(this.myVirtualChildren);
        for (Item childItem : children) {
            result.add(new TfsTreeNode(this, childItem.getItem(), childItem.getType() == ItemType.Folder, false));
        }
        return result.toArray(new SimpleNode[result.size()]);
    }

    protected void update(PresentationData presentation) {
        if (this.isRoot()) {
            presentation.addText(this.myTreeContext.myServer.getPresentableUri(), this.getPlainAttributes());
            presentation.setIcon(TFSIcons.Teamserver);
        } else {
            if (this.isDirectory()) {
                presentation.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                presentation.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(this.getFileName()).getIcon());
            }
            SimpleTextAttributes attrs = this.myVirtual ? VIRTUAL_ATTRS : (this.myTreeContext.isAccepted(this.myPath) ? this.getPlainAttributes() : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            presentation.addText(this.getFileName(), attrs);
        }
    }

    public String getFileName() {
        return VersionControlPath.getLastComponent(this.myPath);
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isRoot() {
        return "$/".equals(this.myPath);
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeNode", "getPath"));
        }
        return string;
    }

    private TfsTreeNode createFakeChild(String name) {
        String childPath = VersionControlPath.getCombinedServerPath(this.myPath, name);
        return new TfsTreeNode(this, childPath, false, false);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myPath};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    @Nullable
    public TfsTreeNode createForSelection(String serverPath) {
        if (StringUtil.isEmpty((String)serverPath) || "$/".equals(serverPath)) {
            return this;
        }
        TfsTreeNode result = this;
        String[] components = VersionControlPath.getPathComponents(serverPath);
        for (int i = 1; i < components.length; ++i) {
            result = result.createFakeChild(components[i]);
        }
        return result;
    }

    public TfsTreeNode createVirtualSubfolder(String folderName) {
        String childPath = VersionControlPath.getCombinedServerPath(this.myPath, folderName);
        TfsTreeNode child = new TfsTreeNode(this, childPath, true, true);
        this.myVirtualChildren.add(child);
        return child;
    }
}

