/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.StylusLanguage;

public class StylusLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        StylusLanguage stylusLanguage = StylusLanguage.INSTANCE;
        if (stylusLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/settings/StylusLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return stylusLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "org/jetbrains/plugins/stylus/settings/StylusLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return "border-radius()\n  -webkit-border-radius arguments\n  -moz-border-radius arguments\n  border-radius arguments\n  \nbody\n  font 12px Helvetica, Arial, sans-serif\n  \na.button\n  border-radius 5px";
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)StylusLanguage.INSTANCE);
        defaultSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        defaultSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = defaultSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        return defaultSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }
}

