/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.inspection;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.dom.ConverterUtil;
import com.intellij.struts2.dom.ExtendableClassConverter;
import com.intellij.struts2.dom.inspection.Struts2ModelInspectionVisitor;
import com.intellij.struts2.dom.params.ParamNameConverter;
import com.intellij.struts2.dom.params.ParamsElement;
import com.intellij.struts2.dom.struts.HasResultType;
import com.intellij.struts2.dom.struts.StrutsRoot;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.ActionMethodConverter;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.action.StrutsPathReferenceConverter;
import com.intellij.struts2.dom.struts.impl.path.ResultTypeResolver;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.strutspackage.ResultType;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Struts2ModelInspection
extends BasicDomElementsInspection<StrutsRoot> {
    public boolean ignoreExtendableClass;

    public Struts2ModelInspection() {
        super(StrutsRoot.class, new Class[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(StrutsBundle.message("inspections.struts2.model.do.not.check.extendable.class", new Object[0]), (InspectionProfileEntry)this, "ignoreExtendableClass");
    }

    public void checkFileElement(DomFileElement<StrutsRoot> strutsRootDomFileElement, DomElementAnnotationHolder holder) {
        Module module = strutsRootDomFileElement.getModule();
        if (module == null) {
            return;
        }
        XmlFile xmlFile = strutsRootDomFileElement.getFile();
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        Set<StrutsFileSet> fileSets = StrutsManager.getInstance(xmlFile.getProject()).getAllConfigFileSets(module);
        for (StrutsFileSet strutsFileSet : fileSets) {
            if (!strutsFileSet.hasFile(virtualFile)) continue;
            super.checkFileElement(strutsRootDomFileElement, holder);
            break;
        }
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        ResultType resultType;
        Result result;
        Converter converter = value.getConverter();
        if (converter instanceof ExtendableClassConverter) {
            return false;
        }
        if (converter instanceof ParamNameConverter && (result = (Result)DomUtil.getParentOfType((DomElement)value, Result.class, (boolean)false)) != null) {
            resultType = result.getEffectiveResultType();
            if (resultType == null) {
                return false;
            }
            String resultTypeValue = resultType.getName().getStringValue();
            if (resultTypeValue != null && ResultTypeResolver.isChainOrRedirectType(resultTypeValue)) {
                return false;
            }
        }
        String stringValue = value.getStringValue();
        if (converter instanceof ActionMethodConverter && ConverterUtil.hasWildcardReference(stringValue)) {
            return false;
        }
        if (converter instanceof StrutsPathReferenceConverter) {
            if (stringValue == null) {
                return false;
            }
            if (!((ParamsElement)value).getParams().isEmpty()) {
                return false;
            }
            resultType = ((HasResultType)value).getEffectiveResultType();
            if (resultType == null) {
                return false;
            }
            if (!ResultTypeResolver.hasResultTypeContributor(resultType.getName().getStringValue())) {
                return false;
            }
            if (ConverterUtil.hasWildcardReference(stringValue)) {
                Action action = (Action)DomUtil.getParentOfType((DomElement)value, Action.class, (boolean)true);
                return action != null && !action.isWildcardMapping();
            }
            if (StringUtil.startsWith((CharSequence)stringValue, (CharSequence)"${")) {
                return false;
            }
            if (URLUtil.containsScheme((String)stringValue)) {
                return false;
            }
        }
        return true;
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        int oldSize = holder.getSize();
        element.accept((DomElementVisitor)new Struts2ModelInspectionVisitor(holder, this.ignoreExtendableClass));
        if (oldSize == holder.getSize()) {
            super.checkDomElement(element, holder, helper);
        }
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{StrutsBundle.message("inspections.group.path.name", new Object[0]), this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/inspection/Struts2ModelInspection", "getGroupPath"));
        }
        return stringArray;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("Struts2ModelInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/inspection/Struts2ModelInspection", "getShortName"));
        }
        return "Struts2ModelInspection";
    }
}

