/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl.path;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.impl.path.ResultTypeResolver;
import com.intellij.struts2.dom.struts.impl.path.StrutsResultContributor;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.util.ArrayUtil;
import icons.Struts2Icons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionChainOrRedirectResultContributor
extends StrutsResultContributor {
    @Override
    public boolean matchesResultType(@NotNull @NonNls String resultType) {
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/struts2/dom/struts/impl/path/ActionChainOrRedirectResultContributor", "matchesResultType"));
        }
        return ResultTypeResolver.isChainOrRedirectType(resultType);
    }

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/dom/struts/impl/path/ActionChainOrRedirectResultContributor", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/struts2/dom/struts/impl/path/ActionChainOrRedirectResultContributor", "createReferences"));
        }
        StrutsModel model = StrutsManager.getInstance(psiElement.getProject()).getModelByFile((XmlFile)psiElement.getContainingFile());
        if (model == null) {
            return false;
        }
        String currentPackage = this.getNamespace(psiElement);
        if (currentPackage == null) {
            return false;
        }
        ActionChainReference chainReference = new ActionChainReference((XmlTag)psiElement, currentPackage, model);
        references.add((PsiReference)chainReference);
        return true;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/struts2/dom/struts/impl/path/ActionChainOrRedirectResultContributor", "getPathReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/dom/struts/impl/path/ActionChainOrRedirectResultContributor", "getPathReference"));
        }
        return this.createDefaultPathReference(path, element, Struts2Icons.Action);
    }

    private static class ActionChainReference
    extends PsiReferenceBase<XmlTag>
    implements EmptyResolveMessageProvider {
        private final String currentPackage;
        private final StrutsModel model;

        private ActionChainReference(XmlTag psiElement, String currentPackage, StrutsModel model) {
            super((PsiElement)psiElement, true);
            this.currentPackage = currentPackage;
            this.model = model;
        }

        public PsiElement resolve() {
            XmlTagValue tagValue = ((XmlTag)this.myElement).getValue();
            String path = PathReference.trimPath((String)tagValue.getText());
            int namespacePrefixIndex = path.lastIndexOf("/");
            String namespace = namespacePrefixIndex != -1 ? path.substring(0, namespacePrefixIndex) : this.currentPackage;
            String strippedPath = path.substring(namespacePrefixIndex != -1 ? namespacePrefixIndex + 1 : 0);
            List<Action> actions = this.model.findActionsByName(strippedPath, namespace);
            if (actions.size() == 1) {
                Action action = actions.get(0);
                return action.getXmlTag();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            List<Action> allActions = this.model.getActionsForNamespace(null);
            ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(allActions.size());
            for (Action action : allActions) {
                String actionPath = action.getName().getStringValue();
                if (actionPath == null) continue;
                boolean isInCurrentPackage = Comparing.equal((String)action.getNamespace(), (String)this.currentPackage);
                String actionNamespace = action.getNamespace();
                String fullPath = !Comparing.equal((String)actionNamespace, (String)"/") && !isInCurrentPackage ? actionNamespace + "/" + actionPath : actionPath;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)action.getXmlTag(), (String)fullPath).withBoldness(isInCurrentPackage).withIcon(Struts2Icons.Action).withTypeText(action.getNamespace());
                variants.add(builder);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/path/ActionChainOrRedirectResultContributor$ActionChainReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve Action '" + this.getValue() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/path/ActionChainOrRedirectResultContributor$ActionChainReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

