/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.model.constant.contributor;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.struts2.model.constant.StrutsConstant;
import com.intellij.struts2.model.constant.StrutsConstantContributor;
import com.intellij.struts2.model.constant.contributor.ConstantValueClassConverter;
import com.intellij.struts2.model.constant.contributor.DelimitedStringValuesConverter;
import com.intellij.struts2.model.constant.contributor.ResultTypeConverter;
import com.intellij.struts2.model.constant.contributor.StringValuesConverter;
import com.intellij.struts2.model.constant.contributor.StrutsPackageConverter;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.converters.values.BooleanValueConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class StrutsConstantContributorBase
implements StrutsConstantContributor {
    private static final Converter<String> BOOLEAN_CONVERTER = new BooleanValueConverter(false);
    private static final Converter<String> INTEGER_CONVERTER = new NumberValueConverter(Integer.class, false);

    @NonNls
    @NotNull
    protected abstract String getRequiredPluginClassName();

    @Override
    public boolean isAvailable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/model/constant/contributor/StrutsConstantContributorBase", "isAvailable"));
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(this.getRequiredPluginClassName(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false)) != null;
    }

    protected static StrutsConstant addBooleanProperty(@NonNls String propertyName) {
        return new StrutsConstant(propertyName, BOOLEAN_CONVERTER);
    }

    protected static StrutsConstant addIntegerProperty(@NonNls String propertyName) {
        return new StrutsConstant(propertyName, INTEGER_CONVERTER);
    }

    protected static StrutsConstant addStringProperty(@NonNls String propertyName) {
        return new StrutsConstant(propertyName, null);
    }

    protected static StrutsConstant addStringValuesProperty(@NonNls String propertyName, String ... values) {
        return new StrutsConstant(propertyName, (Converter)new StringValuesConverter(values));
    }

    protected static StrutsConstant addDelimitedStringValuesProperty(@NonNls String propertyName) {
        return new StrutsConstant(propertyName, (Converter)new DelimitedStringValuesConverter());
    }

    protected static StrutsConstant addClassWithShortcutProperty(@NonNls String propertyName, @NonNls String baseClass, Pair<String, String> ... shortcuts) {
        HashMap<String, String> shortCutToPsiClassMap = new HashMap<String, String>();
        for (Pair<String, String> shortcut : shortcuts) {
            shortCutToPsiClassMap.put((String)shortcut.first, (String)shortcut.second);
        }
        return new StrutsConstant(propertyName, (Converter)new ConstantValueClassConverter(baseClass, shortCutToPsiClassMap));
    }

    protected static StrutsConstant addStrutsPackage(@NonNls String propertyName) {
        return new StrutsConstant(propertyName, (Converter)new StrutsPackageConverter());
    }

    protected static StrutsConstant addResultTypeProperty(@NonNls String propertyName) {
        return new StrutsConstant(propertyName, (Converter)new ResultTypeConverter());
    }
}

