/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph.dnd;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.yfilesGraph.dnd.BasicWebFacetProjectViewDnDSupport;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.graph.beans.BasicPagesEdge;
import com.intellij.seam.graph.beans.BasicPagesNode;
import com.intellij.seam.graph.beans.PageNode;
import com.intellij.seam.model.xml.PagesDomModelManager;
import com.intellij.seam.model.xml.PagesModel;
import com.intellij.seam.model.xml.pages.Page;
import com.intellij.seam.model.xml.pages.Pages;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagesProjectViewDnDSupport
extends BasicWebFacetProjectViewDnDSupport<BasicPagesNode, BasicPagesEdge> {
    private final XmlFile myXmlFile;

    public PagesProjectViewDnDSupport(XmlFile xmlFile, GraphBuilder<BasicPagesNode, BasicPagesEdge> builder, @NotNull WebFacet facetScope) {
        if (facetScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetScope", "com/intellij/seam/graph/dnd/PagesProjectViewDnDSupport", "<init>"));
        }
        super(builder, facetScope);
        this.myXmlFile = xmlFile;
    }

    private static Function<Pages, PageNode> getPageNodeFunction(@NotNull String webPath) {
        if (webPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webPath", "com/intellij/seam/graph/dnd/PagesProjectViewDnDSupport", "getPageNodeFunction"));
        }
        return pages -> {
            if (webPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webPath", "com/intellij/seam/graph/dnd/PagesProjectViewDnDSupport", "lambda$getPageNodeFunction$0"));
            }
            Page page = pages.addPage();
            page.getViewId().setStringValue(webPath);
            return new PageNode((Page)page.createStableCopy(), webPath);
        };
    }

    private static PageNode startInWCA(final Pages pages, final Function<Pages, PageNode> function) {
        return (PageNode)new WriteCommandAction<PageNode>(pages.getManager().getProject(), new PsiFile[]{DomUtil.getFile((DomElement)pages)}){

            protected void run(@NotNull Result<PageNode> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/dnd/PagesProjectViewDnDSupport$1", "run"));
                }
                result.setResult(function.fun((Object)pages));
            }
        }.execute().getResultObject();
    }

    @Nullable
    private Pages getPages() {
        PagesModel pagesModel = PagesDomModelManager.getInstance(this.myXmlFile.getProject()).getPagesModel(this.myXmlFile);
        if (pagesModel != null) {
            return (Pages)((DomFileElement)pagesModel.getRoots().get(0)).getRootElement();
        }
        return null;
    }

    @Nullable
    protected BasicPagesNode createNodeObject(@NotNull String webPath) {
        if (webPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webPath", "com/intellij/seam/graph/dnd/PagesProjectViewDnDSupport", "createNodeObject"));
        }
        Pages pages = this.getPages();
        return pages != null ? PagesProjectViewDnDSupport.startInWCA(pages, PagesProjectViewDnDSupport.getPageNodeFunction(webPath)) : null;
    }

    protected boolean areNodesEquals(@NotNull String webPath, @NotNull BasicPagesNode nodeObject) {
        if (webPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webPath", "com/intellij/seam/graph/dnd/PagesProjectViewDnDSupport", "areNodesEquals"));
        }
        if (nodeObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject", "com/intellij/seam/graph/dnd/PagesProjectViewDnDSupport", "areNodesEquals"));
        }
        return webPath.equals(nodeObject.getName());
    }
}

