/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.compiler;

import java.util.HashMap;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ReconcileWorkingCopyOperation;

public class ReconcileContext {
    private ReconcileWorkingCopyOperation operation;
    private org.eclipse.jdt.internal.core.CompilationUnit workingCopy;

    public ReconcileContext(ReconcileWorkingCopyOperation operation, org.eclipse.jdt.internal.core.CompilationUnit workingCopy) {
        this.operation = operation;
        this.workingCopy = workingCopy;
    }

    public CompilationUnit getAST(int astLevel, boolean resolveBindings) throws JavaModelException {
        if (this.operation.astLevel != astLevel || !this.operation.resolveBindings & resolveBindings) {
            ASTParser parser = ASTParser.newParser(astLevel);
            parser.setCompilerOptions(this.workingCopy.getJavaProject().getOptions(true));
            if (resolveBindings && JavaProject.hasJavaNature(this.workingCopy.getJavaProject().getProject())) {
                parser.setResolveBindings(true);
            }
            parser.setSource(this.workingCopy);
            return (CompilationUnit)parser.createAST(this.operation.progressMonitor);
        }
        return this.operation.makeConsistent(this.workingCopy, null);
    }

    public int getASTLevel() {
        return this.operation.astLevel;
    }

    public boolean isResolvingBindings() {
        return this.operation.resolveBindings;
    }

    public IJavaElementDelta getDelta() {
        return this.operation.deltaBuilder.delta;
    }

    public CategorizedProblem[] getProblems(String markerType) {
        if (this.operation.problems == null) {
            return null;
        }
        return (CategorizedProblem[])this.operation.problems.get(markerType);
    }

    public ICompilationUnit getWorkingCopy() {
        return this.workingCopy;
    }

    public void resetAST() {
        this.operation.ast = null;
        this.putProblems("org.eclipse.jdt.core.problem", null);
        this.putProblems("org.eclipse.jdt.core.task", null);
    }

    public void putProblems(String markerType, CategorizedProblem[] problems) {
        if (this.operation.problems == null) {
            this.operation.problems = new HashMap();
        }
        this.operation.problems.put(markerType, problems);
    }
}

