/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;

public abstract class AbstractMouseDragGesture
extends AbstractGesture {
    private AbstractGesture.Observer observer;
    private Node eventTarget;

    public AbstractMouseDragGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    protected abstract void mousePressed(MouseEvent var1);

    protected abstract void mouseDragDetected(MouseEvent var1);

    protected abstract void mouseReleased(MouseEvent var1);

    protected abstract void mouseExited(MouseEvent var1);

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        assert (e != null);
        assert (e instanceof MouseEvent);
        assert (e.getEventType() == MouseEvent.MOUSE_PRESSED);
        assert (e.getTarget() instanceof Node);
        assert (observer != null);
        this.observer = observer;
        this.eventTarget = (Node)e.getTarget();
        assert (this.eventTarget.getOnDragDetected() == null);
        assert (this.eventTarget.getOnMouseReleased() == null);
        assert (this.eventTarget.getOnMouseExited() == null);
        this.eventTarget.setOnDragDetected(e1 -> {
            try {
                this.mouseDragDetected((MouseEvent)e1);
            }
            finally {
                this.performTermination();
            }
        });
        this.eventTarget.setOnMouseReleased(e1 -> {
            try {
                this.mouseReleased((MouseEvent)e1);
            }
            finally {
                this.performTermination();
            }
        });
        this.eventTarget.setOnMouseExited(e1 -> {
            try {
                this.mouseExited((MouseEvent)e1);
            }
            finally {
                this.performTermination();
            }
        });
        try {
            this.mousePressed((MouseEvent)e);
        }
        catch (RuntimeException x) {
            this.performTermination();
            throw x;
        }
    }

    private void performTermination() {
        this.eventTarget.setOnDragDetected(null);
        this.eventTarget.setOnMouseReleased(null);
        this.eventTarget.setOnMouseExited(null);
        try {
            this.observer.gestureDidTerminate(this);
        }
        finally {
            this.observer = null;
            this.eventTarget = null;
        }
    }
}

