/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;

public final class CardinalPoint
extends Enum<CardinalPoint> {
    public static final /* enum */ CardinalPoint N = new CardinalPoint();
    public static final /* enum */ CardinalPoint NE = new CardinalPoint();
    public static final /* enum */ CardinalPoint E = new CardinalPoint();
    public static final /* enum */ CardinalPoint SE = new CardinalPoint();
    public static final /* enum */ CardinalPoint S = new CardinalPoint();
    public static final /* enum */ CardinalPoint SW = new CardinalPoint();
    public static final /* enum */ CardinalPoint W = new CardinalPoint();
    public static final /* enum */ CardinalPoint NW = new CardinalPoint();
    private static final /* synthetic */ CardinalPoint[] $VALUES;

    public static CardinalPoint[] values() {
        return (CardinalPoint[])$VALUES.clone();
    }

    public static CardinalPoint valueOf(String name) {
        return Enum.valueOf(CardinalPoint.class, name);
    }

    public CardinalPoint getOpposite() {
        CardinalPoint result;
        switch (this) {
            case N: {
                result = S;
                break;
            }
            case NE: {
                result = SW;
                break;
            }
            case E: {
                result = W;
                break;
            }
            case SE: {
                result = NW;
                break;
            }
            case S: {
                result = N;
                break;
            }
            case SW: {
                result = NE;
                break;
            }
            case W: {
                result = E;
                break;
            }
            case NW: {
                result = SE;
                break;
            }
            default: {
                assert (false) : "unexpected cardinal point:" + (Object)((Object)this);
                result = N;
            }
        }
        return result;
    }

    public Point2D getPosition(Bounds bounds) {
        double y;
        double x;
        switch (this) {
            case N: {
                x = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
                y = bounds.getMinY();
                break;
            }
            case NE: {
                x = bounds.getMaxX();
                y = bounds.getMinY();
                break;
            }
            case E: {
                x = bounds.getMaxX();
                y = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
                break;
            }
            case SE: {
                x = bounds.getMaxX();
                y = bounds.getMaxY();
                break;
            }
            case S: {
                x = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
                y = bounds.getMaxY();
                break;
            }
            case SW: {
                x = bounds.getMinX();
                y = bounds.getMaxY();
                break;
            }
            case W: {
                x = bounds.getMinX();
                y = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
                break;
            }
            case NW: {
                x = bounds.getMinX();
                y = bounds.getMinY();
                break;
            }
            default: {
                assert (false) : "unexpected cardinal point:" + (Object)((Object)this);
                x = bounds.getMinX();
                y = bounds.getMinY();
            }
        }
        return new Point2D(x, y);
    }

    public Bounds getResizedBounds(Bounds currentBounds, double dx, double dy) {
        double newMaxY;
        double newMinY;
        double newMaxX;
        double newMinX;
        double minX = currentBounds.getMinX();
        double maxX = currentBounds.getMaxX();
        switch (this) {
            case SW: 
            case W: 
            case NW: {
                newMinX = Math.min(minX + dx, maxX);
                newMaxX = maxX;
                break;
            }
            case NE: 
            case E: 
            case SE: {
                newMinX = minX;
                newMaxX = Math.max(maxX + dx, minX);
                break;
            }
            case N: 
            case S: {
                newMinX = minX;
                newMaxX = maxX;
                break;
            }
            default: {
                assert (false) : "unexpected value=" + (Object)((Object)this);
                newMinX = minX;
                newMaxX = maxX;
            }
        }
        double minY = currentBounds.getMinY();
        double maxY = currentBounds.getMaxY();
        switch (this) {
            case N: 
            case NE: 
            case NW: {
                newMinY = Math.min(minY + dy, maxY);
                newMaxY = maxY;
                break;
            }
            case SE: 
            case S: 
            case SW: {
                newMinY = minY;
                newMaxY = Math.max(maxY + dy, minY);
                break;
            }
            case E: 
            case W: {
                newMinY = minY;
                newMaxY = maxY;
                break;
            }
            default: {
                assert (false) : "unexpected value=" + (Object)((Object)this);
                newMinY = minY;
                newMaxY = maxY;
            }
        }
        return new BoundingBox(newMinX, newMinY, newMaxX - newMinX, newMaxY - newMinY);
    }

    public Point2D clampVector(double dx, double dy) {
        double resultDY;
        double resultDX;
        switch (this) {
            case N: 
            case S: {
                resultDX = 0.0;
                resultDY = dy;
                break;
            }
            case E: 
            case W: {
                resultDX = dx;
                resultDY = 0.0;
                break;
            }
            default: {
                resultDX = dx;
                resultDY = dy;
            }
        }
        return new Point2D(resultDX, resultDY);
    }

    public Bounds snapBounds(Bounds bounds, double ratio) {
        double newMaxY;
        double newMinY;
        double newMaxX;
        double newMinX;
        double minX = bounds.getMinX();
        double minY = bounds.getMinY();
        double maxX = bounds.getMaxX();
        double maxY = bounds.getMaxY();
        double snapWidth = bounds.getHeight() / ratio;
        double snapDX = snapWidth - bounds.getWidth();
        double snapHeight = bounds.getWidth() * ratio;
        double snapDY = snapHeight - bounds.getHeight();
        switch (this) {
            case N: 
            case S: {
                newMinX = minX - snapDX / 2.0;
                newMaxX = maxX + snapDX / 2.0;
                break;
            }
            case E: 
            case W: {
                newMinX = minX;
                newMaxX = maxX;
                break;
            }
            case SW: 
            case NW: {
                newMinX = Math.abs(snapDX) >= Math.abs(snapDY) ? minX - snapDX : minX;
                newMaxX = maxX;
                break;
            }
            case NE: 
            case SE: {
                newMinX = minX;
                if (Math.abs(snapDX) >= Math.abs(snapDY)) {
                    newMaxX = maxX + snapDX;
                    break;
                }
                newMaxX = maxX;
                break;
            }
            default: {
                assert (false) : "Unexpected " + (Object)((Object)this);
                newMinX = minX;
                newMaxX = maxX;
            }
        }
        switch (this) {
            case N: 
            case S: {
                newMinY = minY;
                newMaxY = maxY;
                break;
            }
            case E: 
            case W: {
                newMinY = minY - snapDY / 2.0;
                newMaxY = maxY + snapDY / 2.0;
                break;
            }
            case NE: 
            case NW: {
                newMinY = Math.abs(snapDY) > Math.abs(snapDX) ? minY - snapDY : minY;
                newMaxY = maxY;
                break;
            }
            case SE: 
            case SW: {
                newMinY = minY;
                if (Math.abs(snapDY) > Math.abs(snapDX)) {
                    newMaxY = maxY + snapDY;
                    break;
                }
                newMaxY = maxY;
                break;
            }
            default: {
                assert (false) : "Unexpected " + (Object)((Object)this);
                newMinY = minY;
                newMaxY = maxY;
            }
        }
        return new BoundingBox(newMinX, newMinY, newMaxX - newMinX, newMaxY - newMinY);
    }

    static {
        $VALUES = new CardinalPoint[]{N, NE, E, SE, S, SW, W, NW};
    }
}

