/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.appServerIntegrations.AppServerDescriptorsMetaDataProvider;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetConfiguration;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetType;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.application.JavaeeModule;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.ui.packaging.WebApplicationArtifactType;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.jee.EjbFileNameMapping;
import org.jetbrains.idea.maven.ext.jee.JavaeeFacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.ManifestBuilder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class EarFacetImporter
extends JavaeeFacetImporter<JavaeeApplicationFacet, JavaeeApplicationFacetConfiguration, JavaeeApplicationFacetType> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.ext.jee.EarFacetImporter");
    public static final String DEFAULT_FACET_NAME = "JavaEE";
    private static final String MODULES_ELEMENT = "modules";
    private final List<ApplicationXmlAppender> myAppenders = new ArrayList<ApplicationXmlAppender>();

    public EarFacetImporter() {
        super("org.apache.maven.plugins", "maven-ear-plugin", "ear", JavaeeApplicationFacetType.getInstance(), DEFAULT_FACET_NAME);
    }

    @Override
    protected void setupJavaeeFacet(JavaeeApplicationFacet f, MavenProject p) {
    }

    @Override
    protected void prepareRootElement(JavaeeApplicationFacet facet, CompositePackagingElement<?> rootElement, MavenProject mavenProject) {
        String defaultPath;
        super.prepareRootElement(facet, rootElement, mavenProject);
        String sourceDirectory = this.findConfigValue(mavenProject, "earSourceDirectory");
        if (sourceDirectory == null && new File(FileUtil.toSystemDependentName((String)(defaultPath = this.makePath(mavenProject, new String[]{"src/main/application"})))).exists()) {
            sourceDirectory = defaultPath;
        }
        if (sourceDirectory != null) {
            rootElement.addOrFindChild(PackagingElementFactory.getInstance().createDirectoryCopyWithParentDirectories(FileUtil.toSystemIndependentName((String)sourceDirectory), "/"));
        }
    }

    @Override
    protected String getExplodedPath(MavenProject p) {
        String workDirectory = this.findConfigValue(p, "workDirectory");
        if (!StringUtil.isEmptyOrSpaces((String)workDirectory)) {
            if (!FileUtil.isAbsolute((String)workDirectory)) {
                workDirectory = p.getDirectory() + '/' + workDirectory;
            }
            return FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)workDirectory));
        }
        return this.makePath(p, new String[]{p.getBuildDirectory(), p.getFinalName()});
    }

    @Override
    protected String getArchiveOutputPath(MavenProject p) {
        String outputDirectory = this.findConfigValue(p, "outputDirectory");
        if (!StringUtil.isEmptyOrSpaces((String)outputDirectory)) {
            if (!FileUtil.isAbsolute((String)outputDirectory)) {
                outputDirectory = p.getDirectory() + '/' + outputDirectory;
            }
            return FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)outputDirectory));
        }
        return super.getArchiveOutputPath(p);
    }

    protected String getTargetName(MavenProject p) {
        String warName = this.findConfigValue(p, "earName");
        if (!StringUtil.isEmptyOrSpaces((String)warName)) {
            return warName;
        }
        return super.getTargetName(p);
    }

    @Nullable
    public static ConfigFileMetaData findJBossAppDescriptorMetaData() {
        AppServerIntegration[] integrations;
        AppServerDescriptorsMetaDataProvider provider = JavaeeApplicationFacetType.getInstance().getDescriptorsMetaDataProvider();
        for (AppServerIntegration integration : integrations = AppServerIntegrationsManager.getInstance().getAllIntegrations()) {
            for (ConfigFileMetaData data : provider.getMetaData(integration)) {
                if (!data.getId().equals("jboss-app.xml")) continue;
                return data;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected String getJarFileNameForLibrary(MavenProject mavenProject, JavaeeApplicationFacet facet, MavenArtifact mavenArtifact) {
        String fileNameMapping = this.findConfigValue(mavenProject, "fileNameMapping");
        String string = EjbFileNameMapping.generateFileName(mavenArtifact, fileNameMapping);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter", "getJarFileNameForLibrary"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getJarFileNameForModule(MavenProject mavenProject, MavenArtifact depArtifact, MavenProject depProject) {
        String fileNameMapping = this.findConfigValue(mavenProject, "fileNameMapping");
        String string = EjbFileNameMapping.generateFileName(depArtifact, fileNameMapping);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter", "getJarFileNameForModule"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, JavaeeApplicationFacet f, MavenProjectsTree mavenTree, MavenProject p, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        ConfigFileMetaData metaData;
        String descriptorPath = this.findConfigValue(p, "applicationXml");
        if (descriptorPath == null) {
            String descriptorDir = this.findConfigValue(p, "generatedDescriptorLocation");
            if (descriptorDir == null) {
                descriptorDir = p.getBuildDirectory();
            }
            descriptorPath = this.makePath(p, new String[]{descriptorDir, "application.xml"});
        }
        if (!new File(descriptorPath).isAbsolute()) {
            descriptorPath = p.getDirectory() + '/' + descriptorPath;
        }
        this.setDescriptorUrl(f, DeploymentDescriptorsConstants.APPLICATION_XML_META_DATA, VfsUtilCore.pathToUrl((String)descriptorPath));
        if (this.getConfig(p, "jboss") != null && (metaData = EarFacetImporter.findJBossAppDescriptorMetaData()) != null) {
            this.setDescriptorUrl(f, metaData, VfsUtilCore.pathToUrl((String)this.makePath(p, new String[]{p.getBuildDirectory(), "jboss-app.xml"})));
        }
        try {
            super.reimportFacet(modelsProvider, module, rootModel, f, mavenTree, p, changes, mavenProjectToModuleName, postTasks);
            ApplicationXmlAppender[] appenders = this.myAppenders.toArray(new ApplicationXmlAppender[this.myAppenders.size()]);
            this.generateApplicationXml(p, module, f, appenders);
        }
        finally {
            this.myAppenders.clear();
        }
    }

    public void postProcess(Module module, MavenProject p, MavenProjectChanges changes, IdeModifiableModelsProvider modelsProvider) {
        super.postProcess(module, p, changes, modelsProvider);
        this.processSkinnyWars(modelsProvider, module, p);
    }

    private void processSkinnyWars(final IdeModifiableModelsProvider modelsProvider, Module module, MavenProject mavenProject) {
        if (!Boolean.parseBoolean(this.findConfigValue(mavenProject, "skinnyWars", "false"))) {
            return;
        }
        final ArrayList warElements = ContainerUtil.newArrayList();
        ModifiableArtifact earArtifact = this.findArtifact(modelsProvider, module, true);
        List earClasspathFiles = ContainerUtil.map((Collection)StringUtil.split((String)ManifestBuilder.getClasspath((MavenProject)mavenProject), (String)" "), s -> {
            int idx = s.lastIndexOf("/");
            return s.substring(idx == -1 ? 0 : idx + 1);
        });
        if (ContainerUtil.isEmpty((Collection)earClasspathFiles)) {
            return;
        }
        ArtifactUtil.processPackagingElements((Artifact)earArtifact, (PackagingElementType)ArtifactElementType.ARTIFACT_ELEMENT_TYPE, (PackagingElementProcessor)new PackagingElementProcessor<ArtifactPackagingElement>(){

            public boolean process(@NotNull ArtifactPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$1", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$1", "process"));
                }
                Artifact elementArtifact = element.findArtifact(modelsProvider.getPackagingElementResolvingContext());
                if (elementArtifact != null && elementArtifact.getArtifactType() instanceof WebApplicationArtifactType) {
                    CompositePackagingElement parent = path.getLastParent();
                    if (parent == null) {
                        return true;
                    }
                    warElements.add(Pair.pair((Object)parent, (Object)element));
                }
                return true;
            }
        }, (PackagingElementResolvingContext)modelsProvider.getPackagingElementResolvingContext(), (boolean)true);
        for (Pair pair : warElements) {
            FileCopyPackagingElement manifestFileElement;
            CompositePackagingElement libElement;
            CompositePackagingElement webInfElement;
            CompositePackagingElement parent = (CompositePackagingElement)pair.first;
            ArtifactPackagingElement artifactPackagingElement = (ArtifactPackagingElement)pair.second;
            Artifact warArtifact = artifactPackagingElement.findArtifact(modelsProvider.getPackagingElementResolvingContext());
            if (warArtifact == null) continue;
            parent.removeChild((PackagingElement)artifactPackagingElement);
            CompositePackagingElement rootElement = warArtifact.getRootElement();
            if (rootElement instanceof ArtifactRootElement) {
                for (PackagingElement child : rootElement.getChildren()) {
                    parent.addOrFindChild(ArtifactUtil.copyWithChildren((PackagingElement)child, (Project)module.getProject()));
                }
            } else {
                parent.addOrFindChild(ArtifactUtil.copyWithChildren((PackagingElement)rootElement, (Project)module.getProject()));
            }
            if ((webInfElement = parent.findCompositeChild("WEB-INF")) == null || (libElement = webInfElement.findCompositeChild("lib")) == null) continue;
            List toRemove = ContainerUtil.newSmartList();
            for (PackagingElement warLibrary : libElement.getChildren()) {
                List warLibraryFiles = ContainerUtil.newSmartList();
                if (warLibrary instanceof LibraryPackagingElement) {
                    Library library = ((LibraryPackagingElement)warLibrary).findLibrary(modelsProvider.getPackagingElementResolvingContext());
                    if (library == null) continue;
                    Object[] files = library.getUrls(OrderRootType.CLASSES);
                    warLibraryFiles.addAll(ContainerUtil.map((Object[])files, s -> new File(PathUtil.getLocalPath((String)s)).getName()));
                } else if (warLibrary instanceof ArchivePackagingElement) {
                    warLibraryFiles.add(((ArchivePackagingElement)warLibrary).getName());
                }
                if (warLibraryFiles.isEmpty() || !earClasspathFiles.containsAll(warLibraryFiles)) continue;
                toRemove.add(warLibrary);
            }
            libElement.removeChildren((Collection)toRemove);
            CompositePackagingElement metaInfElement = parent.findCompositeChild("META-INF");
            if (metaInfElement == null || (manifestFileElement = (FileCopyPackagingElement)ContainerUtil.find((Iterable)metaInfElement.getChildren(), packagingElement -> packagingElement instanceof FileCopyPackagingElement && "MANIFEST.MF".equals(((FileCopyPackagingElement)packagingElement).getName()))) == null) continue;
            String warModuleName = StringUtil.substringBefore((String)warArtifact.getName(), (String)":");
            String newManifestPath = mavenProject.getBuildDirectory() + "/temp/" + warModuleName + "/META-INF/SKINNY_MANIFEST.MF";
            String filePath = FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)newManifestPath));
            manifestFileElement.setFilePath(filePath);
            manifestFileElement.setRenamedOutputFileName("MANIFEST.MF");
        }
    }

    private void generateApplicationXml(MavenProject mavenProject, final Module module, final JavaeeApplicationFacet facet, final ApplicationXmlAppender[] appenders) {
        final ConfigFileMetaData metaData = DeploymentDescriptorsConstants.APPLICATION_XML_META_DATA;
        final ConfigFileVersion version = this.getDescriptorVersion(mavenProject, metaData);
        final Project project = module.getProject();
        MavenUtil.runWhenInitialized((Project)project, () -> new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$2", "run"));
                }
                ConfigFile descriptor = facet.getApplicationDescriptor();
                if (descriptor == null || descriptor.getVirtualFile() != null) {
                    return;
                }
                VirtualFile file = ConfigFileFactory.getInstance().createFile(project, descriptor.getUrl(), version, true);
                if (file == null) {
                    return;
                }
                try {
                    String fileText = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)file));
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(metaData.getFileName(), (FileType)StdFileTypes.XML, (CharSequence)fileText);
                    JavaeeApplication root = (JavaeeApplication)JamCommonUtil.getRootElement((PsiFile)psiFile, JavaeeApplication.class, (Module)module);
                    if (root != null) {
                        for (ApplicationXmlAppender appender : appenders) {
                            appender.append(root);
                        }
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                        VfsUtil.saveText((VirtualFile)file, (String)StringUtil.convertLineSeparators((String)psiFile.getText(), (String)SystemProperties.getLineSeparator()));
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }.execute());
    }

    private ConfigFileVersion getDescriptorVersion(MavenProject mavenProject, ConfigFileMetaData metaData) {
        String version = this.findConfigValue(mavenProject, "version");
        for (ConfigFileVersion fileVersion : metaData.getVersions()) {
            if (!fileVersion.getName().equals(version)) continue;
            return fileVersion;
        }
        return metaData.getDefaultVersion();
    }

    @Override
    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? JavaeeArtifactUtil.getInstance().getExplodedEarArtifactType() : JavaeeArtifactUtil.getInstance().getEarArtifactType();
    }

    @Override
    protected boolean addFacetDependency(IdeModifiableModelsProvider modelsProvider, final MavenProject mavenProject, JavaeeApplicationFacet facet, final ModifiableArtifact artifact, final Module depModule, final MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter", "addFacetDependency"));
        }
        if ("pom".equals(depArtifact.getType())) {
            return true;
        }
        final JavaeeFacet depFacet = this.findFacetDependency(depModule, modelsProvider, new JavaeeFacetType[]{WebFacetType.getInstance(), EjbFacetType.getInstance()});
        final Artifact artifactDep = EarFacetImporter.findArtifactDependency(depModule, depArtifact, modelsProvider);
        if (depFacet == null) {
            return false;
        }
        this.link(mavenProject, depArtifact, jarFileName, true, new Linker(){

            @Override
            public void link(String dir, @NotNull String jarFileName, Element configElement) {
                boolean isWeb;
                String relativePath;
                if (jarFileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$3", "link"));
                }
                String string = relativePath = StringUtil.isEmpty((String)dir) ? jarFileName : dir + '/' + jarFileName;
                if (artifactDep != null) {
                    PackagingElementFactory factory = PackagingElementFactory.getInstance();
                    CompositePackagingElement parent = EarFacetImporter.this.shouldUnpackNestedArchive(configElement, mavenProject, depArtifact) ? factory.getOrCreateDirectory(artifact.getRootElement(), relativePath) : factory.getOrCreateArchive(artifact.getRootElement(), relativePath);
                    parent.addOrFindChild(factory.createArtifactElement(artifactDep, depModule.getProject()));
                }
                String contextRoot = (isWeb = depFacet.getTypeId().equals(WebFacet.ID)) ? MavenJDOMUtil.findChildValueByPath((Element)configElement, (String)"contextRoot", (String)"/") : null;
                EarFacetImporter.this.writeFacetIntoAppXml(relativePath, isWeb, contextRoot);
            }
        });
        return true;
    }

    private boolean shouldUnpackNestedArchive(Element moduleConfigElement, MavenProject mavenProject, MavenArtifact depArtifact) {
        if (Boolean.valueOf(MavenJDOMUtil.findChildValueByPath((Element)moduleConfigElement, (String)"unpack")).booleanValue()) {
            return true;
        }
        String unpackTypes = this.findConfigValue(mavenProject, "unpackTypes");
        if (unpackTypes == null) {
            return false;
        }
        return StringUtil.split((String)unpackTypes, (String)",").contains(depArtifact.getType());
    }

    @Nullable
    private static Artifact findArtifactDependency(Module depModule, MavenArtifact depArtifact, IdeModifiableModelsProvider modelsProvider) {
        Artifact artifactDep;
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        if ("client".equals(depArtifact.getClassifier()) && (artifactDep = EarFacetImporter.findEjbClientArtifactDependency(depModule, modelsProvider)) != null) {
            return artifactDep;
        }
        for (Artifact artifact : ContainerUtil.concat((Iterable[])new Iterable[]{artifactModel.getArtifactsByType(JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType()), artifactModel.getArtifactsByType(WebArtifactUtil.getInstance().getExplodedWarArtifactType())})) {
            String artifactName = artifact.getName();
            if (!artifactName.startsWith(depModule.getName() + ':') || !"client".equals(depArtifact.getClassifier()) && (artifactName.endsWith("-client") || artifactName.endsWith("-client exploded"))) continue;
            return artifact;
        }
        return null;
    }

    @Override
    protected void addModuleDependency(final IdeModifiableModelsProvider modelsProvider, final MavenProject mavenProject, final ModifiableArtifact artifact, final Module depModule, final MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter", "addModuleDependency"));
        }
        this.link(mavenProject, depArtifact, jarFileName, true, new Linker(){

            @Override
            public void link(String dir, @NotNull String jarFileName, Element configElement) {
                if (jarFileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$4", "link"));
                }
                String parentPath = StringUtil.notNullize((String)dir) + "/";
                EarFacetImporter.this.doAddModuleDependency(modelsProvider, mavenProject, artifact, depModule, depArtifact, jarFileName, parentPath);
            }
        });
    }

    @Override
    protected void addLibraryDependency(final IdeModifiableModelsProvider modelsProvider, Project project, final MavenProject mavenProject, JavaeeFacet facet, final ModifiableArtifact artifact, final Library depLibrary, MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter", "addLibraryDependency"));
        }
        this.link(mavenProject, depArtifact, jarFileName, true, new Linker(){

            @Override
            public void link(String dir, @NotNull String jarFileName, Element configElement) {
                if (jarFileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$5", "link"));
                }
                EarFacetImporter.this.doAddLibraryDependency(modelsProvider, mavenProject, artifact, depLibrary, StringUtil.notNullize((String)dir), jarFileName);
                if ("true".equals(MavenJDOMUtil.findChildValueByPath((Element)configElement, (String)"includeInApplicationXml"))) {
                    String relativePath = StringUtil.notNullize((String)dir);
                    if (relativePath.length() != 0) {
                        relativePath = relativePath + "/";
                    }
                    relativePath = relativePath + jarFileName;
                    EarFacetImporter.this.writeJavaModuleIntoAppXml(relativePath);
                }
            }
        });
    }

    private void writeFacetIntoAppXml(final String relativePath, final boolean isWeb, final @Nullable String contextRoot) {
        this.myAppenders.add(new ApplicationXmlAppender(){

            @Override
            public void append(@NotNull JavaeeApplication root) {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$6", "append"));
                }
                for (JavaeeModule module : root.getModules()) {
                    String uri = isWeb ? (String)module.getWeb().getWebUri().getValue() : (String)module.getEjb().getValue();
                    if (uri == null || !uri.equals(relativePath)) continue;
                    return;
                }
                JavaeeModule module = root.addModule();
                (isWeb ? module.getWeb().getWebUri() : module.getEjb()).setValue((Object)relativePath);
                if (contextRoot != null) {
                    module.getWeb().getContextRoot().setValue((Object)contextRoot);
                }
            }
        });
    }

    private void writeJavaModuleIntoAppXml(final String relativePath) {
        this.myAppenders.add(new ApplicationXmlAppender(){

            @Override
            public void append(@NotNull JavaeeApplication root) {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter$7", "append"));
                }
                for (JavaeeModule each : root.getModules()) {
                    String javaModule = each.getJava().getStringValue();
                    if (javaModule == null || !javaModule.equals(relativePath)) continue;
                    return;
                }
                JavaeeModule m = root.addModule();
                m.getJava().setStringValue(relativePath);
            }
        });
    }

    void link(MavenProject mavenProject, MavenArtifact depArtifact, @NotNull String jarFileName, boolean supportsCustomName, Linker linker) {
        if (jarFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/idea/maven/ext/jee/EarFacetImporter", "link"));
        }
        Element moduleConfigElement = this.findModuleConfig(mavenProject, depArtifact);
        String excluded = MavenJDOMUtil.findChildValueByPath((Element)moduleConfigElement, (String)"excluded");
        if ("true".equals(excluded)) {
            return;
        }
        String dir = MavenJDOMUtil.findChildValueByPath((Element)moduleConfigElement, (String)"bundleDir");
        if ("".equals(dir)) {
            dir = null;
        } else if (dir != null) {
            dir = dir.replace('\\', '/');
            dir = StringUtil.trimStart((String)dir, (String)"/");
            dir = StringUtil.trimEnd((String)dir, (String)"/");
        }
        if (supportsCustomName) {
            jarFileName = MavenJDOMUtil.findChildValueByPath((Element)moduleConfigElement, (String)"bundleFileName", (String)jarFileName);
        }
        if ("jar".equals(depArtifact.getType()) || "ejb-client".equals(depArtifact.getType())) {
            if (dir == null) {
                dir = this.findConfigValue(mavenProject, "defaultLibBundleDir");
            }
            if (dir == null) {
                dir = this.findConfigValue(mavenProject, "defaultJavaBundleDir");
            }
        }
        linker.link(dir, jarFileName, moduleConfigElement);
    }

    @Nullable
    private Element findModuleConfig(MavenProject project, MavenArtifact depArtifact) {
        String modulePrefix = EarFacetImporter.getModulePrefix(depArtifact) + "Module";
        Element config = this.findConfigElementForArtifact(depArtifact, project, MODULES_ELEMENT, modulePrefix);
        if (config != null) {
            return config;
        }
        return this.findConfigElementForArtifact(depArtifact, project, MODULES_ELEMENT, StringUtil.capitalize((String)modulePrefix));
    }

    private static String getModulePrefix(MavenArtifact depArtifact) {
        String result = depArtifact.getType();
        if ("war".equals(result)) {
            result = "web";
        }
        return EarFacetImporter.convertIntoCamelCase(result);
    }

    private static String convertIntoCamelCase(String type) {
        List names = StringUtil.split((String)type, (String)"-");
        String result = "";
        for (String each : names) {
            result = result + StringUtil.capitalize((String)each);
        }
        return StringUtil.decapitalize((String)result);
    }

    private static interface ApplicationXmlAppender {
        public void append(@NotNull JavaeeApplication var1);
    }

    static abstract class Linker {
        Linker() {
        }

        public abstract void link(@Nullable String var1, @NotNull String var2, Element var3);
    }
}

