/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class OutputFileNameMappingResolver {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("@\\{(.+?)\\}@");

    @NotNull
    public static String resolve(String text, MavenArtifact artifact) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = PROPERTY_PATTERN.matcher(text);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("groupId", artifact.getGroupId());
        properties.put("artifactId", artifact.getArtifactId());
        properties.put("version", artifact.getVersion());
        properties.put("baseVersion", artifact.getBaseVersion());
        properties.put("extension", artifact.getExtension());
        String classifier = artifact.getClassifier();
        properties.put("classifier", classifier);
        String dashClassifier = StringUtil.isEmptyOrSpaces((String)classifier) ? "" : "-" + classifier;
        properties.put("dashClassifier?", dashClassifier);
        properties.put("dashClassifier", dashClassifier);
        int end = 0;
        while (matcher.find()) {
            result.append(text, end, matcher.start());
            end = matcher.end();
            String propertyName = matcher.group(1);
            String value = (String)properties.get(propertyName);
            if (value == null) continue;
            result.append(value);
        }
        result.append(text, end, text.length());
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/OutputFileNameMappingResolver", "resolve"));
        }
        return string;
    }
}

