/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlProvider;

public class MavenUmlNode
extends DiagramNodeBase<MavenElement> {
    private final MavenElement myElement;
    private String myFQN;
    private String myName;
    private Icon myIcon;

    public MavenUmlNode(@NotNull MavenElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/ext/uml/MavenUmlNode", "<init>"));
        }
        super((DiagramProvider)MavenUmlProvider.getInstance());
        this.myElement = element;
        this.myIcon = this.myElement.getIcon();
    }

    public String getTooltip() {
        if (this.myName == null) {
            this.myName = this.myElement.getName();
        }
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public MavenElement getIdentifyingElement() {
        MavenElement mavenElement = this.myElement;
        if (mavenElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/uml/MavenUmlNode", "getIdentifyingElement"));
        }
        return mavenElement;
    }

    protected String getFQN() {
        if (this.myFQN == null) {
            this.myFQN = this.myElement.getId();
        }
        return this.myFQN;
    }
}

