/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.model.messaging;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.model.messaging.UrlPointer;
import com.intellij.spring.websocket.model.xml.MessageBroker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebSocketPrefixes {
    private static final String MESSAGE_BROKER_REGISTRY = "org.springframework.messaging.simp.config.MessageBrokerRegistry";
    private static final String SET_APPLICATION_PREFIXES = "setApplicationDestinationPrefixes";
    private static final String SET_USER_PREFIX = "setUserDestinationPrefix";
    @NotNull
    private final Module myModule;
    @NotNull
    private final MultiMap<SpringMessagingType, UrlPointer> myPrefixes;

    public SpringWebSocketPrefixes(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "<init>"));
        }
        this.myPrefixes = new MultiMap();
        this.myModule = module;
        this.initDefaultPrefixValues();
        this.getPrefixesFromJavaConfiguration();
        this.getPrefixesFromXmlConfiguration();
    }

    public Collection<UrlPointer> get(@NotNull SpringMessagingType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "get"));
        }
        return this.myPrefixes.get((Object)type);
    }

    private void initDefaultPrefixValues() {
        this.setPrefixes(SpringMessagingType.values(), new UrlPointer(null, ""));
        this.setPrefixes(SpringMessagingType.APP_PREFIX_TYPES, new UrlPointer(null, "/app"));
        this.setPrefixes(SpringMessagingType.USER_PREFIX_TYPES, new UrlPointer(null, "/user"));
    }

    private void getPrefixesFromXmlConfiguration() {
        PsiClass messageBrokerConfiguration = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)"org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration");
        if (messageBrokerConfiguration == null) {
            return;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)messageBrokerConfiguration).withInheritors();
        SpringModel model = SpringManager.getInstance((Project)this.myModule.getProject()).getCombinedModel(this.myModule);
        List messageBrokerConfigurations = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        for (SpringBeanPointer beanPointer : messageBrokerConfigurations) {
            String userPrefix;
            CommonSpringBean bean;
            PomTarget target;
            PsiElement element = beanPointer.getPsiElement();
            if (!(element instanceof PomTargetPsiElement) || !((target = ((PomTargetPsiElement)element).getTarget()) instanceof SpringBeanPsiTarget) || !((bean = ((SpringBeanPsiTarget)target).getSpringBean()) instanceof MessageBroker)) continue;
            MessageBroker messageBroker = (MessageBroker)bean;
            String appPrefixes = messageBroker.getApplicationDestinationPrefix().getStringValue();
            if (appPrefixes != null) {
                this.setPrefixes(SpringMessagingType.APP_PREFIX_TYPES, UrlPointer.create(messageBroker.getApplicationDestinationPrefix(), true));
            }
            if ((userPrefix = messageBroker.getUserDestinationPrefix().getStringValue()) == null) continue;
            this.setPrefixes(SpringMessagingType.USER_PREFIX_TYPES, UrlPointer.create(messageBroker.getUserDestinationPrefix(), false));
        }
    }

    private void getPrefixesFromJavaConfiguration() {
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)MESSAGE_BROKER_REGISTRY);
        if (configurerClass == null) {
            return;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)false);
        for (MethodAndPrefixes methodAndPrefixes : MethodAndPrefixes.values()) {
            PsiMethod method = SpringWebSocketPrefixes.getMethodIfOneExists(configurerClass, methodAndPrefixes.methodName);
            if (method == null) continue;
            MethodReferencesSearch.search((PsiMethod)method, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethodCallExpression.class);
                if (methodCallExpression != null) {
                    List arguments = ContainerUtil.mapNotNull((Object[])methodCallExpression.getArgumentList().getExpressions(), expression -> new UrlPointer((PsiElement)expression, StringUtil.trimEnd((String)StringUtil.unquoteString((String)expression.getText()), (String)"/")));
                    if (arguments.isEmpty()) {
                        this.setPrefixes(methodAndPrefixes.prefixTypes, new UrlPointer((PsiElement)methodCallExpression.getArgumentList(), ""));
                    } else {
                        this.setPrefixes(methodAndPrefixes.prefixTypes, arguments);
                    }
                }
                return true;
            });
        }
    }

    private void setPrefixes(@NotNull SpringMessagingType[] types, @NotNull List<UrlPointer> prefixes) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "setPrefixes"));
        }
        if (prefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "setPrefixes"));
        }
        for (SpringMessagingType type : types) {
            this.myPrefixes.remove((Object)type);
            this.myPrefixes.putValues((Object)type, prefixes);
        }
    }

    private void setPrefixes(@NotNull SpringMessagingType[] types, @NotNull UrlPointer prefixPointer) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "setPrefixes"));
        }
        if (prefixPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixPointer", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "setPrefixes"));
        }
        for (SpringMessagingType type : types) {
            this.myPrefixes.remove((Object)type);
            this.myPrefixes.putValue((Object)type, (Object)prefixPointer);
        }
    }

    @Nullable
    private static PsiMethod getMethodIfOneExists(@NotNull PsiClass aClass, @NotNull String methodName) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "getMethodIfOneExists"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes", "getMethodIfOneExists"));
        }
        PsiMethod[] methods = aClass.findMethodsByName(methodName, false);
        if (methods.length != 1) {
            return null;
        }
        return methods[0];
    }

    private static enum MethodAndPrefixes {
        APP("setApplicationDestinationPrefixes", SpringMessagingType.APP_PREFIX_TYPES),
        USER("setUserDestinationPrefix", SpringMessagingType.USER_PREFIX_TYPES);

        public final String methodName;
        public final SpringMessagingType[] prefixTypes;

        private MethodAndPrefixes(String name, SpringMessagingType[] types) {
            this.methodName = name;
            this.prefixTypes = types;
        }
    }
}

