/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.websocket.model.xml.Handlers;
import com.intellij.spring.websocket.model.xml.MessageBroker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringWebSocketImplicitBeansProvider
extends CustomLocalComponentsDiscoverer {
    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/websocket/providers/SpringWebSocketImplicitBeansProvider", "getCustomComponents"));
        }
        Module module = model.getModule();
        if (module == null || module.isDisposed() || !(model instanceof LocalXmlModel)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/providers/SpringWebSocketImplicitBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        DomFileElement root = ((LocalXmlModel)model).getRoot();
        HashSet enabledBeans = ContainerUtil.newHashSet();
        if (root != null) {
            if (SpringDomUtils.hasElement((DomFileElement)root, Handlers.class)) {
                enabledBeans.addAll(SpringWebSocketImplicitBeansProvider.getEnabledConfigurationBeans(module, "org.springframework.web.socket.config.annotation.EnableWebSocket"));
            }
            if (SpringDomUtils.hasElement((DomFileElement)root, MessageBroker.class)) {
                enabledBeans.addAll(SpringWebSocketImplicitBeansProvider.getEnabledConfigurationBeans(module, "org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker"));
            }
        }
        HashSet hashSet = enabledBeans;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/providers/SpringWebSocketImplicitBeansProvider", "getCustomComponents"));
        }
        return hashSet;
    }

    @NotNull
    private static Collection<CommonSpringBean> getEnabledConfigurationBeans(@NotNull Module module, String anno) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/providers/SpringWebSocketImplicitBeansProvider", "getEnabledConfigurationBeans"));
        }
        PsiClass enableAnnoClass = SpringCommonUtils.findLibraryClass((Module)module, (String)anno);
        if (enableAnnoClass == null) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/providers/SpringWebSocketImplicitBeansProvider", "getEnabledConfigurationBeans"));
            }
            return set;
        }
        LocalAnnotationModel model = SpringManager.getInstance((Project)enableAnnoClass.getProject()).getLocalSpringModel(enableAnnoClass, module);
        Collection<Object> collection = model == null ? Collections.emptySet() : ContainerUtil.mapNotNull((Collection)model.getAllCommonBeans(), SpringBeanPointer::getSpringBean);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/providers/SpringWebSocketImplicitBeansProvider", "getEnabledConfigurationBeans"));
        }
        return collection;
    }
}

