/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.model.utils.AntPathMatcher;
import com.intellij.spring.websocket.model.messaging.SpringMessagingModel;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.references.SpringMessagingReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMessagingReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    private final SpringMessagingType[] myMessagingTypes;

    public SpringMessagingReferenceProvider(SpringMessagingType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/websocket/references/SpringMessagingReferenceProvider", "<init>"));
        }
        this.myMessagingTypes = types;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/websocket/references/SpringMessagingReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/websocket/references/SpringMessagingReferenceProvider", "getReferencesByElement"));
        }
        SpringMessagingModel model = this.getModel(element);
        if (model == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/references/SpringMessagingReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String url = StringUtil.unquoteString((String)element.getText());
        List variants = ContainerUtil.filter(model.getUrls(this.myMessagingTypes), variant -> {
            if (variant.isPattern) {
                return AntPathMatcher.match((String)variant.lookupString, (String)url);
            }
            return variant.presentation.equals(url);
        });
        if (variants.isEmpty()) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new SpringMessagingReference(element, this.myMessagingTypes)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/references/SpringMessagingReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        SpringMessagingReference[] springMessagingReferenceArray = SpringMessagingReference.createReferences(element, variants, this.myMessagingTypes);
        if (springMessagingReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/references/SpringMessagingReferenceProvider", "getReferencesByElement"));
        }
        return springMessagingReferenceArray;
    }

    @Nullable
    private SpringMessagingModel getModel(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/websocket/references/SpringMessagingReferenceProvider", "getModel"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module == null ? null : new SpringMessagingModel(module);
    }
}

