/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.mantis.MantisFilter;
import com.intellij.tasks.mantis.MantisProject;
import com.intellij.tasks.mantis.MantisTask;
import com.intellij.tasks.mantis.model.FilterData;
import com.intellij.tasks.mantis.model.IssueData;
import com.intellij.tasks.mantis.model.IssueHeaderData;
import com.intellij.tasks.mantis.model.MantisConnectLocator;
import com.intellij.tasks.mantis.model.MantisConnectPortType;
import com.intellij.tasks.mantis.model.ProjectData;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.math.BigInteger;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Mantis")
public class MantisRepository
extends BaseRepositoryImpl {
    private static final boolean DEBUG_ALL_PROJECTS = Boolean.getBoolean("tasks.mantis.debug.all.projects");
    private static final String SOAP_API_LOCATION = "/api/soap/mantisconnect.php";
    private static final Pattern ID_PATTERN = Pattern.compile("\\d+");
    private static final Logger LOG = Logger.getInstance(MantisRepository.class);
    private List<MantisProject> myProjects = null;
    private boolean myAllProjectsAvailable = true;
    private MantisProject myCurrentProject;
    private MantisFilter myCurrentFilter;

    public MantisRepository() {
    }

    public MantisRepository(TaskRepositoryType type) {
        super(type);
    }

    public MantisRepository(MantisRepository other) {
        super((BaseRepositoryImpl)other);
        this.myCurrentProject = other.getCurrentProject();
        this.myCurrentFilter = other.getCurrentFilter();
        this.myProjects = other.myProjects;
        this.myAllProjectsAvailable = other.myAllProjectsAvailable;
    }

    @NotNull
    public BaseRepository clone() {
        MantisRepository mantisRepository = new MantisRepository(this);
        if (mantisRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository", "clone"));
        }
        return mantisRepository;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/tasks/mantis/MantisRepository", "extractId"));
        }
        Matcher matcher = ID_PATTERN.matcher(taskName);
        return matcher.find() ? matcher.group() : null;
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator cancelled) throws Exception {
        if (cancelled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelled", "com/intellij/tasks/mantis/MantisRepository", "getIssues"));
        }
        if (this.myCurrentProject == null || this.myCurrentFilter == null) {
            throw new Exception(TaskBundle.message("failure.configuration", new Object[0]));
        }
        this.ensureProjectsRefreshed();
        MantisConnectPortType soap = this.createSoap();
        ArrayList<Task> tasks = new ArrayList<Task>(limit);
        int pageNumber = offset / 20 + 1;
        while (tasks.size() < limit) {
            cancelled.checkCanceled();
            int pageSize = Math.min(20, limit - tasks.size());
            List<Task> issuesFromPage = this.getIssuesFromPage(soap, pageNumber, pageSize);
            tasks.addAll(issuesFromPage);
            if (issuesFromPage.size() < pageSize) break;
            ++pageNumber;
        }
        return tasks.toArray(new Task[tasks.size()]);
    }

    private List<Task> getIssuesFromPage(@NotNull MantisConnectPortType soap, int pageNumber, int pageSize) throws Exception {
        if (soap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "soap", "com/intellij/tasks/mantis/MantisRepository", "getIssuesFromPage"));
        }
        ArrayList collectedHeaders = new ArrayList();
        boolean isWorkaround = this.myCurrentProject.isUnspecified() && !this.myAllProjectsAvailable;
        List<MantisProject> projects = isWorkaround ? this.myProjects : Collections.singletonList(this.myCurrentProject);
        for (MantisProject project : projects) {
            if (isWorkaround && project.isUnspecified()) continue;
            assert (!project.isUnspecified() || this.myAllProjectsAvailable);
            Object[] headers = this.fetchProjectIssues(soap, project, this.myCurrentFilter, pageNumber, pageSize);
            ContainerUtil.addAll(collectedHeaders, (Object[])headers);
        }
        return ContainerUtil.mapNotNull(collectedHeaders, (Function)((NullableFunction)issueData -> {
            if (issueData.getId() == null || issueData.getSummary() == null) {
                return null;
            }
            return new MantisTask((IssueHeaderData)issueData, this);
        }));
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/mantis/MantisRepository", "findTask"));
        }
        IssueData data = this.fetchIssueById(this.createSoap(), id);
        if (data == null || data.getId() == null || data.getSummary() == null) {
            return null;
        }
        return new MantisTask(data, this);
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){

            protected void doTest() throws Exception {
                MantisRepository.this.myProjects = null;
                try {
                    MantisRepository.this.refreshProjects();
                }
                catch (Exception e) {
                    throw MantisRepository.this.handleException(e);
                }
            }

            public void cancel() {
            }
        };
    }

    @NotNull
    public List<MantisProject> getProjects() throws Exception {
        this.ensureProjectsRefreshed();
        List<Object> list = this.myProjects == null ? Collections.emptyList() : this.myProjects;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository", "getProjects"));
        }
        return list;
    }

    private void ensureProjectsRefreshed() throws Exception {
        if (this.myProjects == null) {
            this.refreshProjects();
        }
    }

    void refreshProjects() throws Exception {
        MantisConnectPortType soap = this.createSoap();
        this.myAllProjectsAvailable = this.checkAllProjectsAvailable(soap);
        ArrayList<MantisProject> projects = new ArrayList<MantisProject>(ContainerUtil.map((Object[])this.fetchUserProjects(soap), data -> new MantisProject((ProjectData)data)));
        LinkedList<MantisFilter> commonFilters = new LinkedList<MantisFilter>();
        for (MantisProject project : projects) {
            FilterData[] rawFilters = this.fetchProjectFilters(soap, project);
            LinkedList<MantisFilter> projectFilters = new LinkedList<MantisFilter>();
            for (FilterData data2 : rawFilters) {
                MantisFilter filter = new MantisFilter(data2);
                if (data2.getProject_id().intValue() == 0) {
                    commonFilters.add(filter);
                }
                projectFilters.add(filter);
            }
            projectFilters.add(0, MantisFilter.newUndefined());
            project.setFilters(projectFilters);
        }
        Collections.sort(commonFilters, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        commonFilters.add(0, MantisFilter.newUndefined());
        MantisProject undefined = MantisProject.newUndefined();
        undefined.setFilters(commonFilters);
        projects.add(0, undefined);
        this.myProjects = projects;
    }

    private boolean checkAllProjectsAvailable(MantisConnectPortType soap) throws Exception {
        try {
            boolean available;
            String version = soap.mc_version();
            boolean bl = available = !DEBUG_ALL_PROJECTS && VersionComparatorUtil.compare((String)version, (String)"1.2.9") >= 0;
            if (!available) {
                LOG.info("Using Mantis version without 'All Projects' support: " + version);
            }
            return available;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private Exception handleException(@NotNull Exception e) throws Exception {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/mantis/MantisRepository", "handleException"));
        }
        if (e instanceof AxisFault) {
            this.resetConfiguration();
            throw new Exception(TaskBundle.message("failure.server.message", ((AxisFault)e).getFaultString()), e);
        }
        throw e;
    }

    @NotNull
    private MantisConnectPortType createSoap() throws Exception {
        if (this.isUseProxy()) {
            for (Pair pair : HttpConfigurable.getInstance().getJvmProperties(false, null)) {
                String key = (String)pair.first;
                String value = (String)pair.second;
                if (key.equals("proxy.authentication.username")) {
                    AxisProperties.setProperty((String)"http.proxyUser", (String)value);
                    continue;
                }
                if (key.equals("proxy.authentication.password")) {
                    AxisProperties.setProperty((String)"http.proxyPassword", (String)value);
                    continue;
                }
                AxisProperties.setProperty((String)key, (String)value);
            }
        }
        MantisConnectPortType mantisConnectPortType = new MantisConnectLocator().getMantisConnectPort(new URL(this.getUrl() + SOAP_API_LOCATION));
        if (mantisConnectPortType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository", "createSoap"));
        }
        return mantisConnectPortType;
    }

    @Nullable
    private IssueData fetchIssueById(@NotNull MantisConnectPortType soap, @NotNull String id) throws Exception {
        if (soap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "soap", "com/intellij/tasks/mantis/MantisRepository", "fetchIssueById"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/mantis/MantisRepository", "fetchIssueById"));
        }
        try {
            return soap.mc_issue_get(this.getUsername(), this.getPassword(), BigInteger.valueOf(Integer.valueOf(id).intValue()));
        }
        catch (RemoteException e) {
            throw this.handleException(e);
        }
    }

    @NotNull
    private ProjectData[] fetchUserProjects(@NotNull MantisConnectPortType soap) throws Exception {
        ProjectData[] projectDataArray;
        if (soap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "soap", "com/intellij/tasks/mantis/MantisRepository", "fetchUserProjects"));
        }
        try {
            projectDataArray = soap.mc_projects_get_user_accessible(this.getUsername(), this.getPassword());
        }
        catch (RemoteException e) {
            throw this.handleException(e);
        }
        if (projectDataArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository", "fetchUserProjects"));
        }
        return projectDataArray;
    }

    @NotNull
    private FilterData[] fetchProjectFilters(@NotNull MantisConnectPortType soap, @NotNull MantisProject project) throws Exception {
        FilterData[] filterDataArray;
        if (soap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "soap", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectFilters"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectFilters"));
        }
        try {
            filterDataArray = soap.mc_filter_get(this.getUsername(), this.getPassword(), BigInteger.valueOf(project.getId()));
        }
        catch (RemoteException e) {
            throw this.handleException(e);
        }
        if (filterDataArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectFilters"));
        }
        return filterDataArray;
    }

    @NotNull
    private IssueHeaderData[] fetchProjectIssues(@NotNull MantisConnectPortType soap, @NotNull MantisProject project, @NotNull MantisFilter filter, int pageNumber, int pageSize) throws Exception {
        block8: {
            IssueHeaderData[] issueHeaderDataArray;
            if (soap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "soap", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectIssues"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectIssues"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectIssues"));
            }
            try {
                if (!filter.isUnspecified()) break block8;
                issueHeaderDataArray = soap.mc_project_get_issue_headers(this.getUsername(), this.getPassword(), BigInteger.valueOf(project.getId()), BigInteger.valueOf(pageNumber), BigInteger.valueOf(pageSize));
            }
            catch (RemoteException e) {
                throw this.handleException(e);
            }
            if (issueHeaderDataArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectIssues"));
            }
            return issueHeaderDataArray;
        }
        IssueHeaderData[] issueHeaderDataArray = soap.mc_filter_get_issue_headers(this.getUsername(), this.getPassword(), BigInteger.valueOf(project.getId()), BigInteger.valueOf(filter.getId()), BigInteger.valueOf(pageNumber), BigInteger.valueOf(pageSize));
        if (issueHeaderDataArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository", "fetchProjectIssues"));
        }
        return issueHeaderDataArray;
    }

    private void resetConfiguration() {
        block4: {
            if (this.myProjects != null) {
                for (MantisProject project : this.myProjects) {
                    if (!project.isUnspecified()) continue;
                    this.myCurrentProject = project;
                    for (MantisFilter filter : project.getFilters()) {
                        if (!filter.isUnspecified()) continue;
                        this.myCurrentFilter = filter;
                        break block4;
                    }
                    break;
                }
            } else {
                this.myCurrentProject = null;
                this.myCurrentFilter = null;
            }
        }
    }

    @Nullable
    public MantisProject getCurrentProject() {
        return this.myCurrentProject;
    }

    public void setCurrentProject(@Nullable MantisProject currentProject) {
        this.myCurrentProject = currentProject;
    }

    @Nullable
    public MantisFilter getCurrentFilter() {
        return this.myCurrentFilter;
    }

    public void setCurrentFilter(@Nullable MantisFilter currentFilter) {
        this.myCurrentFilter = currentFilter;
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.myUsername) && StringUtil.isNotEmpty((String)this.myPassword);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MantisRepository repository = (MantisRepository)((Object)o);
        if (!Comparing.equal((Object)this.getCurrentProject(), (Object)repository.getCurrentProject())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getCurrentFilter(), (Object)repository.getCurrentFilter())) {
            return false;
        }
        if (!Comparing.equal(this.myProjects, repository.myProjects)) {
            return false;
        }
        return this.myAllProjectsAvailable == repository.myAllProjectsAvailable;
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF;
    }
}

