/*
 * Decompiled with CFR 0.152.
 */
package util;

public class StringUtil {
    private static final String ESCAPE_START = "IDEA-ESCAPE-START";
    private static final String ESCAPE_END = "IDEA-ESCAPE-END";

    public static String escape(String str) {
        String escaped = StringUtil.doEscape(str);
        return str.equals(escaped) ? str : ESCAPE_START + escaped + ESCAPE_END;
    }

    private static String doEscape(String str) {
        StringBuilder buffer = new StringBuilder();
        block8: for (int idx = 0; idx < str.length(); ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block8;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String hexCode = Integer.toHexString(ch).toUpperCase();
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        continue block8;
                    }
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }
}

